/*
 * Decompiled with CFR 0.152.
 */
package aima.search.informed;

import aima.search.framework.Node;
import aima.search.framework.NodeExpander;
import aima.search.framework.Problem;
import aima.search.framework.Search;
import aima.search.framework.SearchUtils;
import java.util.List;

public class HillClimbingSearch
extends NodeExpander
implements Search {
    private SearchOutcome outcome = SearchOutcome.FAILURE;
    private Object lastState = null;

    @Override
    public List search(Problem problem) throws Exception {
        this.clearInstrumentation();
        this.outcome = SearchOutcome.FAILURE;
        this.lastState = null;
        Node node = new Node(problem.getInitialState());
        Node node2 = null;
        while (true) {
            List<Node> list;
            if ((node2 = this.getHighestValuedNodeFrom(list = this.expandNode(node, problem), problem)) == null || this.getValue(problem, node2) <= this.getValue(problem, node)) {
                if (problem.isGoalState(node.getState())) {
                    this.outcome = SearchOutcome.SOLUTION_FOUND;
                }
                this.lastState = node.getState();
                return SearchUtils.actionsFromNodes(node.getPathFromRoot());
            }
            node = node2;
        }
    }

    public SearchOutcome getOutcome() {
        return this.outcome;
    }

    public Object getLastSearchState() {
        return this.lastState;
    }

    private Node getHighestValuedNodeFrom(List list, Problem problem) {
        double d = Double.NEGATIVE_INFINITY;
        Node node = null;
        for (int i = 0; i < list.size(); ++i) {
            Node node2 = (Node)list.get(i);
            double d2 = this.getValue(problem, node2);
            if (!(d2 > d)) continue;
            d = d2;
            node = node2;
        }
        return node;
    }

    private double getValue(Problem problem, Node node) {
        return -1.0 * this.getHeuristic(problem, node);
    }

    private double getHeuristic(Problem problem, Node node) {
        return problem.getHeuristicFunction().getHeuristicValue(node.getState());
    }

    public static enum SearchOutcome {
        FAILURE,
        SOLUTION_FOUND;

    }
}

