/*
 * Decompiled with CFR 0.152.
 */
package aima.search.informed;

import aima.search.framework.EvaluationFunction;
import aima.search.framework.Node;
import aima.search.framework.NodeExpander;
import aima.search.framework.Problem;
import aima.search.framework.Search;
import aima.search.framework.SearchUtils;
import aima.search.informed.SearchResult;
import java.util.ArrayList;
import java.util.List;

public class RecursiveBestFirstSearch
extends NodeExpander
implements Search {
    private final EvaluationFunction evaluationFunction;
    private static final String MAX_RECURSIVE_DEPTH = "maxRecursiveDepth";
    private static final String PATH_COST = "pathCost";
    private static final Double INFINITY = Double.MAX_VALUE;

    public RecursiveBestFirstSearch(EvaluationFunction evaluationFunction) {
        this.evaluationFunction = evaluationFunction;
    }

    @Override
    public List<String> search(Problem problem) throws Exception {
        List<String> list = new ArrayList<String>();
        this.clearInstrumentation();
        Node node = new Node(problem.getInitialState());
        SearchResult searchResult = this.rbfs(problem, node, this.evaluationFunction.getValue(problem, node), INFINITY, 0);
        if (searchResult.getOutcome() == SearchResult.SearchOutcome.SOLUTION_FOUND) {
            Node node2 = searchResult.getSolution();
            list = SearchUtils.actionsFromNodes(node2.getPathFromRoot());
            this.setPathCost(node2.getPathCost());
        }
        return list;
    }

    @Override
    public void clearInstrumentation() {
        super.clearInstrumentation();
        this.metrics.set(MAX_RECURSIVE_DEPTH, 0);
        this.metrics.set(PATH_COST, 0.0);
    }

    public void setMaxRecursiveDepth(int n) {
        int n2 = this.metrics.getInt(MAX_RECURSIVE_DEPTH);
        if (n > n2) {
            this.metrics.set(MAX_RECURSIVE_DEPTH, n);
        }
    }

    public int getMaxRecursiveDepth() {
        return this.metrics.getInt(MAX_RECURSIVE_DEPTH);
    }

    public double getPathCost() {
        return this.metrics.getDouble(PATH_COST);
    }

    public void setPathCost(Double d) {
        this.metrics.set(PATH_COST, d);
    }

    private SearchResult rbfs(Problem problem, Node node, Double d, Double d2, int n) {
        SearchResult searchResult;
        int n2;
        this.setMaxRecursiveDepth(n);
        if (problem.isGoalState(node.getState())) {
            return new SearchResult(node, d2);
        }
        List<Node> list = this.expandNode(node, problem);
        if (0 == list.size()) {
            return new SearchResult(null, INFINITY);
        }
        double[] dArray = new double[list.size()];
        int n3 = list.size();
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = Math.max(this.evaluationFunction.getValue(problem, list.get(n2)), d);
        }
        do {
            if (dArray[n2 = this.getBestFValueIndex(dArray)] > d2) {
                return new SearchResult(null, dArray[n2]);
            }
            int n4 = this.getNextBestFValueIndex(dArray, n2);
            searchResult = this.rbfs(problem, list.get(n2), dArray[n2], Math.min(d2, dArray[n4]), n + 1);
            dArray[n2] = searchResult.getFCostLimit();
        } while (searchResult.getOutcome() != SearchResult.SearchOutcome.SOLUTION_FOUND);
        return searchResult;
    }

    private int getBestFValueIndex(double[] dArray) {
        int n = 0;
        Double d = INFINITY;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] < d)) continue;
            d = dArray[i];
            n = i;
        }
        return n;
    }

    private int getNextBestFValueIndex(double[] dArray, int n) {
        int n2 = n;
        Double d = INFINITY;
        for (int i = 0; i < dArray.length; ++i) {
            if (i == n || !(dArray[i] < d)) continue;
            d = dArray[i];
            n2 = i;
        }
        return n2;
    }
}

