/*
 * Decompiled with CFR 0.152.
 */
package aima.search.map;

import aima.search.map.Map;
import aima.search.map.Point2D;
import aima.util.LabeledGraph;
import aima.util.Util;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;

public class ExtendableMap
implements Map {
    private final LabeledGraph<String, Double> links = new LabeledGraph();
    private final Hashtable<String, Point2D> locationPositions = new Hashtable();

    public void clear() {
        this.links.clear();
        this.locationPositions.clear();
    }

    public void clearLinks() {
        this.links.clear();
    }

    @Override
    public List<String> getLocations() {
        return this.links.getVertexLabels();
    }

    public boolean isLocation(String string) {
        return this.links.isVertexLabel(string);
    }

    @Override
    public List<String> getLocationsLinkedTo(String string) {
        List<String> list = this.links.getSuccessors(string);
        Collections.sort(list);
        return list;
    }

    @Override
    public Double getDistance(String string, String string2) {
        return this.links.get(string, string2);
    }

    public void addUnidirectionalLink(String string, String string2, Double d) {
        this.links.set(string, string2, d);
    }

    public void addBidirectionalLink(String string, String string2, Double d) {
        this.links.set(string, string2, d);
        this.links.set(string2, string, d);
    }

    @Override
    public String randomlyGenerateDestination() {
        return Util.selectRandomlyFromList(this.getLocations());
    }

    public void removeUnidirectionalLink(String string, String string2) {
        this.links.remove(string, string2);
    }

    public void removeBidirectionalLink(String string, String string2) {
        this.links.remove(string, string2);
        this.links.remove(string2, string);
    }

    public void setPosition(String string, double d, double d2) {
        this.locationPositions.put(string, new Point2D(d, d2));
    }

    public void setDistAndDirToRefLocation(String string, double d, int n) {
        Point2D point2D = new Point2D(-Math.sin((double)n * Math.PI / 180.0) * d, Math.cos((double)n * Math.PI / 180.0) * d);
        this.links.addVertex(string);
        this.locationPositions.put(string, point2D);
    }

    @Override
    public Point2D getPosition(String string) {
        return this.locationPositions.get(string);
    }
}

