/*
 * Decompiled with CFR 0.152.
 */
package aima.search.nqueens;

import aima.basic.XYLocation;
import java.util.ArrayList;
import java.util.List;

public class NQueensBoard {
    int[][] board;
    int size;

    public NQueensBoard(int n) {
        this.size = n;
        this.board = new int[this.size][this.size];
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                this.board[i][j] = 0;
            }
        }
    }

    public void addQueenAt(XYLocation xYLocation) {
        if (!this.queenExistsAt(xYLocation)) {
            this.board[xYLocation.getXCoOrdinate()][xYLocation.getYCoOrdinate()] = 1;
        }
    }

    public void removeQueenFrom(XYLocation xYLocation) {
        if (this.board[xYLocation.getXCoOrdinate()][xYLocation.getYCoOrdinate()] == 1) {
            this.board[xYLocation.getXCoOrdinate()][xYLocation.getYCoOrdinate()] = 0;
        }
    }

    private boolean queenExistsAt(int n, int n2) {
        return this.board[n][n2] == 1;
    }

    public boolean queenExistsAt(XYLocation xYLocation) {
        return this.queenExistsAt(xYLocation.getXCoOrdinate(), xYLocation.getYCoOrdinate());
    }

    public void moveQueen(XYLocation xYLocation, XYLocation xYLocation2) {
        if (this.queenExistsAt(xYLocation) && !this.queenExistsAt(xYLocation2)) {
            this.removeQueenFrom(xYLocation);
            this.addQueenAt(xYLocation2);
        }
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                this.board[i][j] = 0;
            }
        }
    }

    public void setBoard(List<XYLocation> list) {
        this.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.addQueenAt(list.get(i));
        }
    }

    public int getNumberOfQueensOnBoard() {
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                if (this.board[i][j] != 1) continue;
                ++n;
            }
        }
        return n;
    }

    public List<XYLocation> getQueenPositions() {
        ArrayList<XYLocation> arrayList = new ArrayList<XYLocation>();
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                if (!this.queenExistsAt(i, j)) continue;
                arrayList.add(new XYLocation(i, j));
            }
        }
        return arrayList;
    }

    private boolean isSquareHorizontallyAttacked(int n, int n2) {
        return this.numberOfHorizontalAttacksOn(n, n2) > 0;
    }

    private boolean isSquareVerticallyAttacked(int n, int n2) {
        return this.numberOfVerticalAttacksOn(n, n2) > 0;
    }

    private boolean isSquareDiagonallyAttacked(int n, int n2) {
        return this.numberOfDiagonalAttacksOn(n, n2) > 0;
    }

    public boolean isSquareUnderAttack(XYLocation xYLocation) {
        int n;
        int n2 = xYLocation.getXCoOrdinate();
        return this.isSquareHorizontallyAttacked(n2, n = xYLocation.getYCoOrdinate()) || this.isSquareVerticallyAttacked(n2, n) || this.isSquareDiagonallyAttacked(n2, n);
    }

    public int getSize() {
        return this.size;
    }

    public void print() {
        System.out.println(this.getBoardPic());
    }

    public String getBoardPic() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                if (this.queenExistsAt(j, i)) {
                    stringBuffer.append(" Q ");
                    continue;
                }
                stringBuffer.append(" - ");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public int getNumberOfAttacksOn(XYLocation xYLocation) {
        int n = xYLocation.getXCoOrdinate();
        int n2 = xYLocation.getYCoOrdinate();
        return this.numberOfHorizontalAttacksOn(n, n2) + this.numberOfVerticalAttacksOn(n, n2) + this.numberOfDiagonalAttacksOn(n, n2);
    }

    private int numberOfHorizontalAttacksOn(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!this.queenExistsAt(i, n2) || i == n) continue;
            ++n3;
        }
        return n3;
    }

    private int numberOfVerticalAttacksOn(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!this.queenExistsAt(n, i) || i == n2) continue;
            ++n3;
        }
        return n3;
    }

    private int numberOfDiagonalAttacksOn(int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = n + 1;
        for (n3 = n2 - 1; n5 < this.size && n3 > -1; ++n5, --n3) {
            if (!this.queenExistsAt(n5, n3)) continue;
            ++n4;
        }
        n5 = n + 1;
        for (n3 = n2 + 1; n5 < this.size && n3 < this.size; ++n5, ++n3) {
            if (!this.queenExistsAt(n5, n3)) continue;
            ++n4;
        }
        n5 = n - 1;
        for (n3 = n2 - 1; n5 > -1 && n3 > -1; --n5, --n3) {
            if (!this.queenExistsAt(n5, n3)) continue;
            ++n4;
        }
        n5 = n - 1;
        for (n3 = n2 + 1; n5 > -1 && n3 < this.size; --n5, ++n3) {
            if (!this.queenExistsAt(n5, n3)) continue;
            ++n4;
        }
        return n4;
    }

    public int hashCode() {
        List<XYLocation> list = this.getQueenPositions();
        int n = 17;
        for (XYLocation xYLocation : list) {
            n = 37 * xYLocation.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NQueensBoard nQueensBoard = (NQueensBoard)object;
        boolean bl = true;
        List<XYLocation> list = this.getQueenPositions();
        for (XYLocation xYLocation : list) {
            if (nQueensBoard.queenExistsAt(xYLocation)) continue;
            bl = false;
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                if (this.queenExistsAt(j, i)) {
                    stringBuffer.append('Q');
                    continue;
                }
                stringBuffer.append('-');
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

