/*
 * Decompiled with CFR 0.152.
 */
package aima.search.uninformed;

import aima.search.framework.Metrics;
import aima.search.framework.NodeExpander;
import aima.search.framework.Problem;
import aima.search.framework.Search;
import aima.search.uninformed.DepthLimitedSearch;
import java.util.ArrayList;
import java.util.List;

public class IterativeDeepeningSearch
extends NodeExpander
implements Search {
    private static String PATH_COST = "pathCost";
    private final int limit = Integer.MAX_VALUE;
    private final Metrics iterationMetrics = new Metrics();

    public IterativeDeepeningSearch() {
        this.iterationMetrics.set(NODES_EXPANDED, 0);
        this.iterationMetrics.set(PATH_COST, 0);
    }

    @Override
    public List search(Problem problem) throws Exception {
        this.iterationMetrics.set(NODES_EXPANDED, 0);
        this.iterationMetrics.set(PATH_COST, 0);
        for (int i = 1; i <= this.limit; ++i) {
            DepthLimitedSearch depthLimitedSearch = new DepthLimitedSearch(i);
            List list = depthLimitedSearch.search(problem);
            this.iterationMetrics.set(NODES_EXPANDED, this.iterationMetrics.getInt(NODES_EXPANDED) + depthLimitedSearch.getMetrics().getInt(NODES_EXPANDED));
            if (this.cutOffResult(list)) continue;
            this.iterationMetrics.set(PATH_COST, depthLimitedSearch.getPathCost());
            return list;
        }
        return new ArrayList();
    }

    private boolean cutOffResult(List list) {
        return list.size() == 1 && list.get(0).equals("cutoff");
    }

    @Override
    public Metrics getMetrics() {
        return this.iterationMetrics;
    }
}

