/*
 * Decompiled with CFR 0.152.
 */
package aima.test.coretest;

import aima.basic.Percept;
import aima.basic.simplerule.ANDCondition;
import aima.basic.simplerule.EQUALCondition;
import aima.basic.simplerule.NOTCondition;
import aima.basic.simplerule.ORCondition;
import aima.basic.simplerule.Rule;
import junit.framework.TestCase;

public class RuleTest
extends TestCase {
    public void testEQUALRule() {
        Rule rule = new Rule(new EQUALCondition("car-in-front-is-braking", "true"), "initiate-braking");
        RuleTest.assertEquals((String)"initiate-braking", (String)rule.getAction());
        RuleTest.assertEquals((String)"if car-in-front-is-braking==true then initiate-braking.", (String)rule.toString());
        RuleTest.assertEquals((boolean)true, (boolean)rule.evaluate(new Percept("car-in-front-is-braking", "true")));
        RuleTest.assertEquals((boolean)false, (boolean)rule.evaluate(new Percept("car-in-front-is-braking", "false")));
        RuleTest.assertEquals((boolean)false, (boolean)rule.evaluate(new Percept("car-in-front-is-indicating", "true")));
    }

    public void testNOTRule() {
        Rule rule = new Rule(new NOTCondition(new EQUALCondition("car-in-front-is-braking", "true")), "initiate-braking");
        RuleTest.assertEquals((String)"initiate-braking", (String)rule.getAction());
        RuleTest.assertEquals((String)"if ![car-in-front-is-braking==true] then initiate-braking.", (String)rule.toString());
        RuleTest.assertEquals((boolean)false, (boolean)rule.evaluate(new Percept("car-in-front-is-braking", "true")));
        RuleTest.assertEquals((boolean)true, (boolean)rule.evaluate(new Percept("car-in-front-is-braking", "false")));
        RuleTest.assertEquals((boolean)true, (boolean)rule.evaluate(new Percept("car-in-front-is-indicating", "true")));
    }

    public void testANDRule() {
        Rule rule = new Rule(new ANDCondition(new EQUALCondition("car-in-front-is-braking", "true"), new EQUALCondition("car-in-front-tires-smoking", "true")), "emergency-braking");
        RuleTest.assertEquals((String)"emergency-braking", (String)rule.getAction());
        RuleTest.assertEquals((String)"if [car-in-front-is-braking==true && car-in-front-tires-smoking==true] then emergency-braking.", (String)rule.toString());
        RuleTest.assertEquals((boolean)false, (boolean)rule.evaluate(new Percept("car-in-front-is-braking", "true")));
        RuleTest.assertEquals((boolean)false, (boolean)rule.evaluate(new Percept("car-in-front-tires-smoking", "true")));
        RuleTest.assertEquals((boolean)true, (boolean)rule.evaluate(new Percept("car-in-front-is-braking", "true", "car-in-front-tires-smoking", "true")));
        RuleTest.assertEquals((boolean)false, (boolean)rule.evaluate(new Percept("car-in-front-is-braking", "false", "car-in-front-tires-smoking", "true")));
        RuleTest.assertEquals((boolean)false, (boolean)rule.evaluate(new Percept("car-in-front-is-braking", "true", "car-in-front-tires-smoking", "false")));
    }

    public void testORRule() {
        Rule rule = new Rule(new ORCondition(new EQUALCondition("car-in-front-is-braking", "true"), new EQUALCondition("car-in-front-tires-smoking", "true")), "emergency-braking");
        RuleTest.assertEquals((String)"emergency-braking", (String)rule.getAction());
        RuleTest.assertEquals((String)"if [car-in-front-is-braking==true || car-in-front-tires-smoking==true] then emergency-braking.", (String)rule.toString());
        RuleTest.assertEquals((boolean)true, (boolean)rule.evaluate(new Percept("car-in-front-is-braking", "true")));
        RuleTest.assertEquals((boolean)true, (boolean)rule.evaluate(new Percept("car-in-front-tires-smoking", "true")));
        RuleTest.assertEquals((boolean)true, (boolean)rule.evaluate(new Percept("car-in-front-is-braking", "true", "car-in-front-tires-smoking", "true")));
        RuleTest.assertEquals((boolean)true, (boolean)rule.evaluate(new Percept("car-in-front-is-braking", "false", "car-in-front-tires-smoking", "true")));
        RuleTest.assertEquals((boolean)true, (boolean)rule.evaluate(new Percept("car-in-front-is-braking", "true", "car-in-front-tires-smoking", "false")));
        RuleTest.assertEquals((boolean)false, (boolean)rule.evaluate(new Percept("car-in-front-is-braking", "false", "car-in-front-tires-smoking", "false")));
    }
}

