/*
 * Decompiled with CFR 0.152.
 */
package aima.test.learningtest;

import aima.learning.framework.DataSet;
import aima.learning.framework.DataSetFactory;
import aima.learning.framework.DataSetSpecification;
import aima.learning.framework.Example;
import aima.learning.neural.IrisDataSetNumerizer;
import aima.util.Pair;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;

public class DataSetTest
extends TestCase {
    private static final String NO = "No";
    private static final String YES = "Yes";
    DataSetSpecification spec;

    public void testLoadsDatasetFile() throws Exception {
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        DataSetTest.assertEquals((int)12, (int)dataSet.size());
        Example example = dataSet.getExample(0);
        DataSetTest.assertEquals((String)YES, (String)example.getAttributeValueAsString("alternate"));
        DataSetTest.assertEquals((String)"$$$", (String)example.getAttributeValueAsString("price"));
        DataSetTest.assertEquals((String)"0-10", (String)example.getAttributeValueAsString("wait_estimate"));
        DataSetTest.assertEquals((String)YES, (String)example.getAttributeValueAsString("will_wait"));
        DataSetTest.assertEquals((String)YES, (String)example.targetValue());
    }

    public void testThrowsExceptionForNonExistentFile() throws FileNotFoundException {
        try {
            DataSet dataSet = new DataSetFactory().fromFile("nonexistent", null, null);
            DataSetTest.fail((String)"should have thrown Exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testLoadsIrisDataSetWithNumericAndStringAttributes() throws Exception {
        DataSet dataSet = DataSetFactory.getIrisDataSet();
        Example example = dataSet.getExample(0);
        DataSetTest.assertEquals((String)"5.1", (String)example.getAttributeValueAsString("sepal_length"));
    }

    public void testNonDestructiveRemoveExample() throws Exception {
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        DataSet dataSet2 = dataSet.removeExample(dataSet.getExample(0));
        DataSetTest.assertEquals((int)12, (int)dataSet.size());
        DataSetTest.assertEquals((int)11, (int)dataSet2.size());
    }

    public void testNumerizesAndDeNumerizesIrisDataSetExample1() throws Exception {
        DataSet dataSet = DataSetFactory.getIrisDataSet();
        Example example = dataSet.getExample(0);
        IrisDataSetNumerizer irisDataSetNumerizer = new IrisDataSetNumerizer();
        Pair<List<Double>, List<Double>> pair = irisDataSetNumerizer.numerize(example);
        DataSetTest.assertEquals(Arrays.asList(5.1, 3.5, 1.4, 0.2), pair.getFirst());
        DataSetTest.assertEquals(Arrays.asList(0.0, 0.0, 1.0), pair.getSecond());
        String string = irisDataSetNumerizer.denumerize(Arrays.asList(0.0, 0.0, 1.0));
        DataSetTest.assertEquals((String)"setosa", (String)string);
    }

    public void testNumerizesAndDeNumerizesIrisDataSetExample2() throws Exception {
        DataSet dataSet = DataSetFactory.getIrisDataSet();
        Example example = dataSet.getExample(51);
        IrisDataSetNumerizer irisDataSetNumerizer = new IrisDataSetNumerizer();
        Pair<List<Double>, List<Double>> pair = irisDataSetNumerizer.numerize(example);
        DataSetTest.assertEquals(Arrays.asList(6.4, 3.2, 4.5, 1.5), pair.getFirst());
        DataSetTest.assertEquals(Arrays.asList(0.0, 1.0, 0.0), pair.getSecond());
        String string = irisDataSetNumerizer.denumerize(Arrays.asList(0.0, 1.0, 0.0));
        DataSetTest.assertEquals((String)"versicolor", (String)string);
    }

    public void testNumerizesAndDeNumerizesIrisDataSetExample3() throws Exception {
        DataSet dataSet = DataSetFactory.getIrisDataSet();
        Example example = dataSet.getExample(100);
        IrisDataSetNumerizer irisDataSetNumerizer = new IrisDataSetNumerizer();
        Pair<List<Double>, List<Double>> pair = irisDataSetNumerizer.numerize(example);
        DataSetTest.assertEquals(Arrays.asList(6.3, 3.3, 6.0, 2.5), pair.getFirst());
        DataSetTest.assertEquals(Arrays.asList(1.0, 0.0, 0.0), pair.getSecond());
        String string = irisDataSetNumerizer.denumerize(Arrays.asList(1.0, 0.0, 0.0));
        DataSetTest.assertEquals((String)"virginica", (String)string);
    }
}

