/*
 * Decompiled with CFR 0.152.
 */
package aima.test.learningtest;

import aima.learning.framework.DataSet;
import aima.learning.framework.DataSetFactory;
import aima.learning.inductive.DecisionTree;
import aima.learning.learners.DecisionTreeLearner;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class DecisionTreeTest
extends TestCase {
    private static final String YES = "Yes";
    private static final String NO = "No";

    public void testActualDecisionTreeClassifiesRestaurantDataSetCorrectly() throws Exception {
        DecisionTreeLearner decisionTreeLearner = new DecisionTreeLearner(DecisionTreeTest.createActualRestaurantDecisionTree(), "Unable to clasify");
        int[] nArray = decisionTreeLearner.test(DataSetFactory.getRestaurantDataSet());
        DecisionTreeTest.assertEquals((int)12, (int)nArray[0]);
        DecisionTreeTest.assertEquals((int)0, (int)nArray[1]);
    }

    public void testInducedDecisionTreeClassifiesRestaurantDataSetCorrectly() throws Exception {
        DecisionTreeLearner decisionTreeLearner = new DecisionTreeLearner(DecisionTreeTest.createInducedRestaurantDecisionTree(), "Unable to clasify");
        int[] nArray = decisionTreeLearner.test(DataSetFactory.getRestaurantDataSet());
        DecisionTreeTest.assertEquals((int)12, (int)nArray[0]);
        DecisionTreeTest.assertEquals((int)0, (int)nArray[1]);
    }

    public void testStumpCreationForSpecifiedAttributeValuePair() throws Exception {
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(NO);
        DecisionTree decisionTree = DecisionTree.getStumpFor(dataSet, "alternate", YES, YES, arrayList, NO);
        DecisionTreeTest.assertNotNull((Object)decisionTree);
    }

    public void testStumpCreationForDataSet() throws Exception {
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        List<DecisionTree> list = DecisionTree.getStumpsFor(dataSet, YES, "Unable to classify");
        DecisionTreeTest.assertEquals((int)26, (int)list.size());
    }

    public void testStumpPredictionForDataSet() throws Exception {
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        List<DecisionTree> list = DecisionTree.getStumpsFor(dataSet, YES, "Unable to classify");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(NO);
        DecisionTree decisionTree = DecisionTree.getStumpFor(dataSet, "hungry", YES, YES, arrayList, "Unable to Classify");
        DecisionTreeLearner decisionTreeLearner = new DecisionTreeLearner(decisionTree, "Unable to Classify");
        int[] nArray = decisionTreeLearner.test(dataSet);
        DecisionTreeTest.assertEquals((int)5, (int)nArray[0]);
        DecisionTreeTest.assertEquals((int)7, (int)nArray[1]);
    }

    private static DecisionTree createInducedRestaurantDecisionTree() {
        DecisionTree decisionTree = new DecisionTree("fri/sat");
        decisionTree.addLeaf(YES, YES);
        decisionTree.addLeaf(NO, NO);
        DecisionTree decisionTree2 = new DecisionTree("type");
        decisionTree2.addLeaf("French", YES);
        decisionTree2.addLeaf("Italian", NO);
        decisionTree2.addNode("Thai", decisionTree);
        decisionTree2.addLeaf("Burger", YES);
        DecisionTree decisionTree3 = new DecisionTree("hungry");
        decisionTree3.addLeaf(NO, NO);
        decisionTree3.addNode(YES, decisionTree2);
        DecisionTree decisionTree4 = new DecisionTree("patrons");
        decisionTree4.addLeaf("None", NO);
        decisionTree4.addLeaf("Some", YES);
        decisionTree4.addNode("Full", decisionTree3);
        return decisionTree4;
    }

    private static DecisionTree createActualRestaurantDecisionTree() {
        DecisionTree decisionTree = new DecisionTree("raining");
        decisionTree.addLeaf(YES, YES);
        decisionTree.addLeaf(NO, NO);
        DecisionTree decisionTree2 = new DecisionTree("bar");
        decisionTree2.addLeaf(YES, YES);
        decisionTree2.addLeaf(NO, NO);
        DecisionTree decisionTree3 = new DecisionTree("fri/sat");
        decisionTree3.addLeaf(YES, YES);
        decisionTree3.addLeaf(NO, NO);
        DecisionTree decisionTree4 = new DecisionTree("alternate");
        decisionTree4.addNode(YES, decisionTree);
        decisionTree4.addLeaf(NO, YES);
        DecisionTree decisionTree5 = new DecisionTree("reservation");
        decisionTree3.addNode(NO, decisionTree2);
        decisionTree3.addLeaf(YES, YES);
        DecisionTree decisionTree6 = new DecisionTree("alternate");
        decisionTree6.addNode(NO, decisionTree5);
        decisionTree6.addNode(YES, decisionTree3);
        DecisionTree decisionTree7 = new DecisionTree("hungry");
        decisionTree7.addLeaf(NO, YES);
        decisionTree7.addNode(YES, decisionTree4);
        DecisionTree decisionTree8 = new DecisionTree("wait_estimate");
        decisionTree8.addLeaf(">60", NO);
        decisionTree8.addNode("30-60", decisionTree6);
        decisionTree8.addNode("10-30", decisionTree7);
        decisionTree8.addLeaf("0-10", YES);
        DecisionTree decisionTree9 = new DecisionTree("patrons");
        decisionTree9.addLeaf("None", NO);
        decisionTree9.addLeaf("Some", YES);
        decisionTree9.addNode("Full", decisionTree8);
        return decisionTree9;
    }
}

