/*
 * Decompiled with CFR 0.152.
 */
package aima.test.learningtest;

import aima.learning.framework.DataSet;
import aima.learning.framework.DataSetFactory;
import aima.learning.inductive.DLTest;
import aima.learning.inductive.DLTestFactory;
import aima.learning.learners.CurrentBestLearner;
import aima.learning.learners.DecisionListLearner;
import aima.learning.learners.DecisionTreeLearner;
import aima.learning.learners.MajorityLearner;
import aima.test.learningtest.MockDLTestFactory;
import aima.test.learningtest.MockDataSetSpecification;
import java.util.ArrayList;
import junit.framework.TestCase;

public class LearnerTests
extends TestCase {
    public void testMajorityLearner() throws Exception {
        MajorityLearner majorityLearner = new MajorityLearner();
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        majorityLearner.train(dataSet);
        int[] nArray = majorityLearner.test(dataSet);
        LearnerTests.assertEquals((int)6, (int)nArray[0]);
        LearnerTests.assertEquals((int)6, (int)nArray[1]);
    }

    public void testDefaultUsedWhenTrainingDataSetHasNoExamples() throws Exception {
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        DecisionTreeLearner decisionTreeLearner = new DecisionTreeLearner();
        DataSet dataSet2 = dataSet.emptyDataSet();
        LearnerTests.assertEquals((int)0, (int)dataSet2.size());
        decisionTreeLearner.train(dataSet2);
        LearnerTests.assertEquals((String)"Unable To Classify", (String)decisionTreeLearner.predict(dataSet.getExample(0)));
    }

    public void testClassificationReturnedWhenAllExamplesHaveTheSameClassification() throws Exception {
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        DecisionTreeLearner decisionTreeLearner = new DecisionTreeLearner();
        DataSet dataSet2 = dataSet.emptyDataSet();
        dataSet2.add(dataSet.getExample(0));
        dataSet2.add(dataSet.getExample(2));
        dataSet2.add(dataSet.getExample(3));
        decisionTreeLearner.train(dataSet2);
        LearnerTests.assertEquals((String)"Yes", (String)decisionTreeLearner.predict(dataSet.getExample(0)));
    }

    public void testMajorityReturnedWhenAttributesToExamineIsEmpty() throws Exception {
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        DecisionTreeLearner decisionTreeLearner = new DecisionTreeLearner();
        DataSet dataSet2 = dataSet.emptyDataSet();
        dataSet2.add(dataSet.getExample(0));
        dataSet2.add(dataSet.getExample(1));
        dataSet2.add(dataSet.getExample(2));
        dataSet2.add(dataSet.getExample(3));
        dataSet2.setSpecification(new MockDataSetSpecification("will_wait"));
        decisionTreeLearner.train(dataSet2);
        LearnerTests.assertEquals((String)"Yes", (String)decisionTreeLearner.predict(dataSet.getExample(1)));
    }

    public void testInducedTreeClassifiesDataSetCorrectly() throws Exception {
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        DecisionTreeLearner decisionTreeLearner = new DecisionTreeLearner();
        decisionTreeLearner.train(dataSet);
        int[] nArray = decisionTreeLearner.test(dataSet);
        LearnerTests.assertEquals((int)12, (int)nArray[0]);
        LearnerTests.assertEquals((int)0, (int)nArray[1]);
    }

    public void testDecisionListLearnerReturnsNegativeDLWhenDataSetEmpty() throws Exception {
        DecisionListLearner decisionListLearner = new DecisionListLearner("Yes", "No", new MockDLTestFactory(null));
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        DataSet dataSet2 = dataSet.emptyDataSet();
        decisionListLearner.train(dataSet2);
        LearnerTests.assertEquals((String)"No", (String)decisionListLearner.predict(dataSet.getExample(0)));
        LearnerTests.assertEquals((String)"No", (String)decisionListLearner.predict(dataSet.getExample(1)));
        LearnerTests.assertEquals((String)"No", (String)decisionListLearner.predict(dataSet.getExample(2)));
    }

    public void testDecisionListLearnerReturnsFailureWhenTestsEmpty() throws Exception {
        DecisionListLearner decisionListLearner = new DecisionListLearner("Yes", "No", new MockDLTestFactory(new ArrayList<DLTest>()));
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        decisionListLearner.train(dataSet);
        LearnerTests.assertEquals((String)"Failure", (String)decisionListLearner.predict(dataSet.getExample(0)));
    }

    public void testDecisionListTestRunOnRestaurantDataSet() throws Exception {
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        DecisionListLearner decisionListLearner = new DecisionListLearner("Yes", "No", new DLTestFactory());
        decisionListLearner.train(dataSet);
        int[] nArray = decisionListLearner.test(dataSet);
        LearnerTests.assertEquals((int)12, (int)nArray[0]);
        LearnerTests.assertEquals((int)0, (int)nArray[1]);
    }

    public void testCurrentBestLearnerOnRestaurantDataSet() throws Exception {
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        CurrentBestLearner currentBestLearner = new CurrentBestLearner("Yes");
        currentBestLearner.train(dataSet);
        int[] nArray = currentBestLearner.test(dataSet);
        LearnerTests.assertEquals((int)12, (int)nArray[0]);
        LearnerTests.assertEquals((int)0, (int)nArray[1]);
    }
}

