/*
 * Decompiled with CFR 0.152.
 */
package aima.test.learningtest.neural;

import aima.learning.neural.BackPropLearning;
import aima.learning.neural.Layer;
import aima.learning.neural.LayerSensitivity;
import aima.learning.neural.LogSigActivationFunction;
import aima.learning.neural.PureLinearActivationFunction;
import aima.learning.neural.Vector;
import aima.util.Matrix;
import junit.framework.TestCase;

public class LayerTests
extends TestCase {
    public void testFeedForward() {
        Matrix matrix = new Matrix(2, 1);
        matrix.set(0, 0, -0.27);
        matrix.set(1, 0, -0.41);
        Vector vector = new Vector(2);
        vector.setValue(0, -0.48);
        vector.setValue(1, -0.13);
        Layer layer = new Layer(matrix, vector, new LogSigActivationFunction());
        Vector vector2 = new Vector(1);
        vector2.setValue(0, 1.0);
        Vector vector3 = new Vector(2);
        vector3.setValue(0, 0.321);
        vector3.setValue(1, 0.368);
        Vector vector4 = layer.feedForward(vector2);
        LayerTests.assertEquals((double)vector3.getValue(0), (double)vector4.getValue(0), (double)0.001);
        LayerTests.assertEquals((double)vector3.getValue(1), (double)vector4.getValue(1), (double)0.001);
        Matrix matrix2 = new Matrix(1, 2);
        matrix2.set(0, 0, 0.09);
        matrix2.set(0, 1, -0.17);
        Vector vector5 = new Vector(1);
        vector5.setValue(0, 0.48);
        Layer layer2 = new Layer(matrix2, vector5, new PureLinearActivationFunction());
        Vector vector6 = layer.getLastActivationValues();
        Vector vector7 = layer2.feedForward(vector6);
        LayerTests.assertEquals((double)0.446, (double)vector7.getValue(0), (double)0.001);
    }

    public void testSensitivityMatrixCalculationFromErrorVector() {
        Matrix matrix = new Matrix(2, 1);
        matrix.set(0, 0, -0.27);
        matrix.set(1, 0, -0.41);
        Vector vector = new Vector(2);
        vector.setValue(0, -0.48);
        vector.setValue(1, -0.13);
        Layer layer = new Layer(matrix, vector, new LogSigActivationFunction());
        Vector vector2 = new Vector(1);
        vector2.setValue(0, 1.0);
        layer.feedForward(vector2);
        Matrix matrix2 = new Matrix(1, 2);
        matrix2.set(0, 0, 0.09);
        matrix2.set(0, 1, -0.17);
        Vector vector3 = new Vector(1);
        vector3.setValue(0, 0.48);
        Layer layer2 = new Layer(matrix2, vector3, new PureLinearActivationFunction());
        Vector vector4 = layer.getLastActivationValues();
        layer2.feedForward(vector4);
        Vector vector5 = new Vector(1);
        vector5.setValue(0, 1.261);
        LayerSensitivity layerSensitivity = new LayerSensitivity(layer2);
        layerSensitivity.sensitivityMatrixFromErrorMatrix(vector5);
        Matrix matrix3 = layerSensitivity.getSensitivityMatrix();
        LayerTests.assertEquals((Object)-2.522, (Object)matrix3.get(0, 0));
    }

    public void testSensitivityMatrixCalculationFromSucceedingLayer() {
        Matrix matrix = new Matrix(2, 1);
        matrix.set(0, 0, -0.27);
        matrix.set(1, 0, -0.41);
        Vector vector = new Vector(2);
        vector.setValue(0, -0.48);
        vector.setValue(1, -0.13);
        Layer layer = new Layer(matrix, vector, new LogSigActivationFunction());
        LayerSensitivity layerSensitivity = new LayerSensitivity(layer);
        Vector vector2 = new Vector(1);
        vector2.setValue(0, 1.0);
        layer.feedForward(vector2);
        Matrix matrix2 = new Matrix(1, 2);
        matrix2.set(0, 0, 0.09);
        matrix2.set(0, 1, -0.17);
        Vector vector3 = new Vector(1);
        vector3.setValue(0, 0.48);
        Layer layer2 = new Layer(matrix2, vector3, new PureLinearActivationFunction());
        Vector vector4 = layer.getLastActivationValues();
        layer2.feedForward(vector4);
        Vector vector5 = new Vector(1);
        vector5.setValue(0, 1.261);
        LayerSensitivity layerSensitivity2 = new LayerSensitivity(layer2);
        layerSensitivity2.sensitivityMatrixFromErrorMatrix(vector5);
        layerSensitivity.sensitivityMatrixFromSucceedingLayer(layerSensitivity2);
        Matrix matrix3 = layerSensitivity.getSensitivityMatrix();
        LayerTests.assertEquals((int)2, (int)matrix3.getRowDimension());
        LayerTests.assertEquals((int)1, (int)matrix3.getColumnDimension());
        LayerTests.assertEquals((double)-0.0495, (double)matrix3.get(0, 0), (double)0.001);
        LayerTests.assertEquals((double)0.0997, (double)matrix3.get(1, 0), (double)0.001);
    }

    public void testWeightUpdateMatrixesFormedCorrectly() {
        Matrix matrix = new Matrix(2, 1);
        matrix.set(0, 0, -0.27);
        matrix.set(1, 0, -0.41);
        Vector vector = new Vector(2);
        vector.setValue(0, -0.48);
        vector.setValue(1, -0.13);
        Layer layer = new Layer(matrix, vector, new LogSigActivationFunction());
        LayerSensitivity layerSensitivity = new LayerSensitivity(layer);
        Vector vector2 = new Vector(1);
        vector2.setValue(0, 1.0);
        layer.feedForward(vector2);
        Matrix matrix2 = new Matrix(1, 2);
        matrix2.set(0, 0, 0.09);
        matrix2.set(0, 1, -0.17);
        Vector vector3 = new Vector(1);
        vector3.setValue(0, 0.48);
        Layer layer2 = new Layer(matrix2, vector3, new PureLinearActivationFunction());
        Vector vector4 = layer.getLastActivationValues();
        layer2.feedForward(vector4);
        Vector vector5 = new Vector(1);
        vector5.setValue(0, 1.261);
        LayerSensitivity layerSensitivity2 = new LayerSensitivity(layer2);
        layerSensitivity2.sensitivityMatrixFromErrorMatrix(vector5);
        layerSensitivity.sensitivityMatrixFromSucceedingLayer(layerSensitivity2);
        Matrix matrix3 = BackPropLearning.calculateWeightUpdates(layerSensitivity2, layer.getLastActivationValues(), 0.1);
        LayerTests.assertEquals((double)0.0809, (double)matrix3.get(0, 0), (double)0.001);
        LayerTests.assertEquals((double)0.0928, (double)matrix3.get(0, 1), (double)0.001);
        Matrix matrix4 = layer2.getLastWeightUpdateMatrix();
        LayerTests.assertEquals((double)0.0809, (double)matrix4.get(0, 0), (double)0.001);
        LayerTests.assertEquals((double)0.0928, (double)matrix4.get(0, 1), (double)0.001);
        Matrix matrix5 = layer2.getPenultimateWeightUpdateMatrix();
        LayerTests.assertEquals((double)0.0, (double)matrix5.get(0, 0), (double)0.001);
        LayerTests.assertEquals((double)0.0, (double)matrix5.get(0, 1), (double)0.001);
        Matrix matrix6 = BackPropLearning.calculateWeightUpdates(layerSensitivity, vector2, 0.1);
        LayerTests.assertEquals((double)0.0049, (double)matrix6.get(0, 0), (double)0.001);
        LayerTests.assertEquals((double)-0.00997, (double)matrix6.get(1, 0), (double)0.001);
        Matrix matrix7 = layer.getLastWeightUpdateMatrix();
        LayerTests.assertEquals((double)0.0049, (double)matrix7.get(0, 0), (double)0.001);
        LayerTests.assertEquals((double)-0.00997, (double)matrix7.get(1, 0), (double)0.001);
        Matrix matrix8 = layer.getPenultimateWeightUpdateMatrix();
        LayerTests.assertEquals((double)0.0, (double)matrix8.get(0, 0), (double)0.001);
        LayerTests.assertEquals((double)0.0, (double)matrix8.get(1, 0), (double)0.001);
    }

    public void testBiasUpdateMatrixesFormedCorrectly() {
        Matrix matrix = new Matrix(2, 1);
        matrix.set(0, 0, -0.27);
        matrix.set(1, 0, -0.41);
        Vector vector = new Vector(2);
        vector.setValue(0, -0.48);
        vector.setValue(1, -0.13);
        Layer layer = new Layer(matrix, vector, new LogSigActivationFunction());
        LayerSensitivity layerSensitivity = new LayerSensitivity(layer);
        Vector vector2 = new Vector(1);
        vector2.setValue(0, 1.0);
        layer.feedForward(vector2);
        Matrix matrix2 = new Matrix(1, 2);
        matrix2.set(0, 0, 0.09);
        matrix2.set(0, 1, -0.17);
        Vector vector3 = new Vector(1);
        vector3.setValue(0, 0.48);
        Layer layer2 = new Layer(matrix2, vector3, new PureLinearActivationFunction());
        LayerSensitivity layerSensitivity2 = new LayerSensitivity(layer2);
        Vector vector4 = layer.getLastActivationValues();
        layer2.feedForward(vector4);
        Vector vector5 = new Vector(1);
        vector5.setValue(0, 1.261);
        layerSensitivity2.sensitivityMatrixFromErrorMatrix(vector5);
        layerSensitivity.sensitivityMatrixFromSucceedingLayer(layerSensitivity2);
        Vector vector6 = BackPropLearning.calculateBiasUpdates(layerSensitivity2, 0.1);
        LayerTests.assertEquals((double)0.2522, (double)vector6.getValue(0), (double)0.001);
        Vector vector7 = layer2.getLastBiasUpdateVector();
        LayerTests.assertEquals((double)0.2522, (double)vector7.getValue(0), (double)0.001);
        Vector vector8 = layer2.getPenultimateBiasUpdateVector();
        LayerTests.assertEquals((double)0.0, (double)vector8.getValue(0), (double)0.001);
        Vector vector9 = BackPropLearning.calculateBiasUpdates(layerSensitivity, 0.1);
        LayerTests.assertEquals((double)0.00495, (double)vector9.getValue(0), (double)0.001);
        LayerTests.assertEquals((double)-0.00997, (double)vector9.getValue(1), (double)0.001);
        Vector vector10 = layer.getLastBiasUpdateVector();
        LayerTests.assertEquals((double)0.00495, (double)vector10.getValue(0), (double)0.001);
        LayerTests.assertEquals((double)-0.00997, (double)vector10.getValue(1), (double)0.001);
        Vector vector11 = layer.getPenultimateBiasUpdateVector();
        LayerTests.assertEquals((double)0.0, (double)vector11.getValue(0), (double)0.001);
        LayerTests.assertEquals((double)0.0, (double)vector11.getValue(1), (double)0.001);
    }

    public void testWeightsAndBiasesUpdatedCorrectly() {
        Matrix matrix = new Matrix(2, 1);
        matrix.set(0, 0, -0.27);
        matrix.set(1, 0, -0.41);
        Vector vector = new Vector(2);
        vector.setValue(0, -0.48);
        vector.setValue(1, -0.13);
        Layer layer = new Layer(matrix, vector, new LogSigActivationFunction());
        LayerSensitivity layerSensitivity = new LayerSensitivity(layer);
        Vector vector2 = new Vector(1);
        vector2.setValue(0, 1.0);
        layer.feedForward(vector2);
        Matrix matrix2 = new Matrix(1, 2);
        matrix2.set(0, 0, 0.09);
        matrix2.set(0, 1, -0.17);
        Vector vector3 = new Vector(1);
        vector3.setValue(0, 0.48);
        Layer layer2 = new Layer(matrix2, vector3, new PureLinearActivationFunction());
        Vector vector4 = layer.getLastActivationValues();
        layer2.feedForward(vector4);
        Vector vector5 = new Vector(1);
        vector5.setValue(0, 1.261);
        LayerSensitivity layerSensitivity2 = new LayerSensitivity(layer2);
        layerSensitivity2.sensitivityMatrixFromErrorMatrix(vector5);
        layerSensitivity.sensitivityMatrixFromSucceedingLayer(layerSensitivity2);
        BackPropLearning.calculateWeightUpdates(layerSensitivity2, layer.getLastActivationValues(), 0.1);
        BackPropLearning.calculateBiasUpdates(layerSensitivity2, 0.1);
        BackPropLearning.calculateWeightUpdates(layerSensitivity, vector2, 0.1);
        BackPropLearning.calculateBiasUpdates(layerSensitivity, 0.1);
        layer2.updateWeights();
        Matrix matrix3 = layer2.getWeightMatrix();
        LayerTests.assertEquals((double)0.171, (double)matrix3.get(0, 0), (double)0.001);
        LayerTests.assertEquals((double)-0.0772, (double)matrix3.get(0, 1), (double)0.001);
        layer2.updateBiases();
        Vector vector6 = layer2.getBiasVector();
        LayerTests.assertEquals((Object)0.7322, (Object)vector6.getValue(0));
        layer.updateWeights();
        Matrix matrix4 = layer.getWeightMatrix();
        LayerTests.assertEquals((double)-0.265, (double)matrix4.get(0, 0), (double)0.001);
        LayerTests.assertEquals((double)-0.419, (double)matrix4.get(1, 0), (double)0.001);
        layer.updateBiases();
        Vector vector7 = layer.getBiasVector();
        LayerTests.assertEquals((double)-0.475, (double)vector7.getValue(0), (double)0.001);
        LayerTests.assertEquals((double)-0.139, (double)vector7.getValue(1), (double)0.001);
    }
}

