/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.fol.kb.data.Chain;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.Term;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class ChainTest
extends TestCase {
    public void testIsEmpty() {
        Chain chain = new Chain();
        ChainTest.assertTrue((boolean)chain.isEmpty());
        chain.addLiteral(new Literal(new Predicate("P", new ArrayList<Term>())));
        ChainTest.assertFalse((boolean)chain.isEmpty());
        ArrayList<Literal> arrayList = new ArrayList<Literal>();
        arrayList.add(new Literal(new Predicate("P", new ArrayList<Term>())));
        chain = new Chain(arrayList);
        ChainTest.assertFalse((boolean)chain.isEmpty());
    }

    public void testContrapositives() {
        Literal literal = new Literal(new Predicate("P", new ArrayList<Term>()));
        Literal literal2 = new Literal(new Predicate("Q", new ArrayList<Term>()), true);
        Literal literal3 = new Literal(new Predicate("R", new ArrayList<Term>()), true);
        Chain chain = new Chain();
        List<Chain> list = chain.getContrapositives();
        ChainTest.assertEquals((int)0, (int)list.size());
        chain.addLiteral(literal);
        list = chain.getContrapositives();
        ChainTest.assertEquals((int)0, (int)list.size());
        chain.addLiteral(literal2);
        list = chain.getContrapositives();
        ChainTest.assertEquals((int)1, (int)list.size());
        ChainTest.assertEquals((String)"<~Q(),P()>", (String)list.get(0).toString());
        chain.addLiteral(literal3);
        list = chain.getContrapositives();
        ChainTest.assertEquals((int)2, (int)list.size());
        ChainTest.assertEquals((String)"<~Q(),P(),~R()>", (String)list.get(0).toString());
        ChainTest.assertEquals((String)"<~R(),P(),~Q()>", (String)list.get(1).toString());
    }
}

