/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.fol.domain.FOLDomain;
import aima.logic.fol.inference.Demodulation;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.parsing.FOLParser;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.TermEquality;
import java.util.ArrayList;
import junit.framework.TestCase;

public class DemodulationTest
extends TestCase {
    private Demodulation demodulation = null;

    public void setUp() {
        this.demodulation = new Demodulation();
    }

    public void testSimpleAtomicExamples() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addConstant("A");
        fOLDomain.addConstant("B");
        fOLDomain.addConstant("C");
        fOLDomain.addConstant("D");
        fOLDomain.addConstant("E");
        fOLDomain.addPredicate("P");
        fOLDomain.addFunction("F");
        fOLDomain.addFunction("G");
        fOLDomain.addFunction("H");
        fOLDomain.addFunction("J");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        Predicate predicate = (Predicate)fOLParser.parse("P(A,F(B,G(A,H(B)),C),D)");
        TermEquality termEquality = (TermEquality)fOLParser.parse("B = E");
        Predicate predicate2 = (Predicate)this.demodulation.apply(termEquality, predicate);
        DemodulationTest.assertFalse((boolean)predicate.equals(predicate2));
        DemodulationTest.assertEquals((String)"P(A,F(E,G(A,H(B)),C),D)", (String)predicate2.toString());
        predicate2 = (Predicate)this.demodulation.apply(termEquality, predicate2);
        DemodulationTest.assertEquals((String)"P(A,F(E,G(A,H(E)),C),D)", (String)predicate2.toString());
        termEquality = (TermEquality)fOLParser.parse("G(x,y) = J(x)");
        predicate2 = (Predicate)this.demodulation.apply(termEquality, predicate);
        DemodulationTest.assertEquals((String)"P(A,F(B,J(A),C),D)", (String)predicate2.toString());
    }

    public void testSimpleAtomicNonExample() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addConstant("A");
        fOLDomain.addConstant("B");
        fOLDomain.addConstant("C");
        fOLDomain.addConstant("D");
        fOLDomain.addConstant("E");
        fOLDomain.addPredicate("P");
        fOLDomain.addFunction("F");
        fOLDomain.addFunction("G");
        fOLDomain.addFunction("H");
        fOLDomain.addFunction("J");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        Predicate predicate = (Predicate)fOLParser.parse("P(A,G(x,B),C)");
        TermEquality termEquality = (TermEquality)fOLParser.parse("G(A,y) = J(y)");
        Predicate predicate2 = (Predicate)this.demodulation.apply(termEquality, predicate);
        DemodulationTest.assertNull((Object)predicate2);
    }

    public void testSimpleClauseExamples() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addConstant("A");
        fOLDomain.addConstant("B");
        fOLDomain.addConstant("C");
        fOLDomain.addConstant("D");
        fOLDomain.addConstant("E");
        fOLDomain.addPredicate("P");
        fOLDomain.addPredicate("Q");
        fOLDomain.addPredicate("W");
        fOLDomain.addFunction("F");
        fOLDomain.addFunction("G");
        fOLDomain.addFunction("H");
        fOLDomain.addFunction("J");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        ArrayList<Literal> arrayList = new ArrayList<Literal>();
        Predicate predicate = (Predicate)fOLParser.parse("Q(z, G(D,B))");
        Predicate predicate2 = (Predicate)fOLParser.parse("P(x, G(A,C))");
        Predicate predicate3 = (Predicate)fOLParser.parse("W(z,x,u,w,y)");
        arrayList.add(new Literal(predicate));
        arrayList.add(new Literal(predicate2));
        arrayList.add(new Literal(predicate3));
        Clause clause = new Clause(arrayList);
        TermEquality termEquality = (TermEquality)fOLParser.parse("G(x,y) = x");
        Clause clause2 = this.demodulation.apply(termEquality, clause);
        DemodulationTest.assertEquals((String)"[P(x,G(A,C)), Q(z,D), W(z,x,u,w,y)]", (String)clause2.toString());
        clause2 = this.demodulation.apply(termEquality, clause2);
        DemodulationTest.assertEquals((String)"[P(x,A), Q(z,D), W(z,x,u,w,y)]", (String)clause2.toString());
    }

    public void testSimpleClauseNonExample() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addConstant("A");
        fOLDomain.addConstant("B");
        fOLDomain.addConstant("C");
        fOLDomain.addPredicate("P");
        fOLDomain.addFunction("F");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        ArrayList<Literal> arrayList = new ArrayList<Literal>();
        Predicate predicate = (Predicate)fOLParser.parse("P(y, F(A,y))");
        arrayList.add(new Literal(predicate));
        Clause clause = new Clause(arrayList);
        TermEquality termEquality = (TermEquality)fOLParser.parse("F(x,B) = C");
        Clause clause2 = this.demodulation.apply(termEquality, clause);
        DemodulationTest.assertNull((Object)clause2);
    }

    public void testBypassReflexivityAxiom() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addConstant("A");
        fOLDomain.addConstant("B");
        fOLDomain.addConstant("C");
        fOLDomain.addPredicate("P");
        fOLDomain.addFunction("F");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        ArrayList<Literal> arrayList = new ArrayList<Literal>();
        Predicate predicate = (Predicate)fOLParser.parse("P(y, F(A,y))");
        arrayList.add(new Literal(predicate));
        Clause clause = new Clause(arrayList);
        TermEquality termEquality = (TermEquality)fOLParser.parse("x = x");
        Clause clause2 = this.demodulation.apply(termEquality, clause);
        DemodulationTest.assertNull((Object)clause2);
    }
}

