/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.common.Token;
import aima.logic.fol.domain.FOLDomain;
import aima.logic.fol.parsing.FOLLexer;
import junit.framework.TestCase;

public class FOLLexerTest
extends TestCase {
    FOLLexer lexer;

    public void setUp() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addConstant("P");
        fOLDomain.addConstant("John");
        fOLDomain.addConstant("Saladin");
        fOLDomain.addFunction("LeftLeg");
        fOLDomain.addFunction("BrotherOf");
        fOLDomain.addFunction("EnemyOf");
        fOLDomain.addPredicate("HasColor");
        fOLDomain.addPredicate("King");
        this.lexer = new FOLLexer(fOLDomain);
    }

    public void testLexBasicExpression() {
        this.lexer.setInput("( P )");
        FOLLexerTest.assertEquals((Object)new Token(2, "("), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(10, "P"), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(3, ")"), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(9999, "EOI"), (Object)this.lexer.nextToken());
    }

    public void testConnectors() {
        this.lexer.setInput(" p  AND q");
        FOLLexerTest.assertEquals((Object)new Token(9, "p"), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(5, "AND"), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(9, "q"), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(9999, "EOI"), (Object)this.lexer.nextToken());
    }

    public void testFunctions() {
        this.lexer.setInput(" LeftLeg(q)");
        FOLLexerTest.assertEquals((Object)new Token(8, "LeftLeg"), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(2, "("), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(9, "q"), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(3, ")"), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(9999, "EOI"), (Object)this.lexer.nextToken());
    }

    public void testPredicate() {
        this.lexer.setInput(" HasColor(r)");
        FOLLexerTest.assertEquals((Object)new Token(7, "HasColor"), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(2, "("), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(9, "r"), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(3, ")"), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(9999, "EOI"), (Object)this.lexer.nextToken());
    }

    public void testMultiArgPredicate() {
        this.lexer.setInput(" King(x,y)");
        FOLLexerTest.assertEquals((Object)new Token(7, "King"), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(2, "("), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(9, "x"), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(4, ","), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(9, "y"), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(3, ")"), (Object)this.lexer.nextToken());
    }

    public void testQuantifier() {
        this.lexer.setInput("FORALL x,y");
        FOLLexerTest.assertEquals((Object)new Token(6, "FORALL"), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(9, "x"), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(4, ","), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(9, "y"), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(9999, "EOI"), (Object)this.lexer.nextToken());
    }

    public void testTermEquality() {
        this.lexer.setInput("BrotherOf(John) = EnemyOf(Saladin)");
        FOLLexerTest.assertEquals((Object)new Token(8, "BrotherOf"), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(2, "("), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(10, "John"), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(3, ")"), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(13, "="), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(8, "EnemyOf"), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(2, "("), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(10, "Saladin"), (Object)this.lexer.nextToken());
        FOLLexerTest.assertEquals((Object)new Token(3, ")"), (Object)this.lexer.nextToken());
    }
}

