/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.fol.SubstVisitor;
import aima.logic.fol.domain.DomainFactory;
import aima.logic.fol.parsing.FOLParser;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.Variable;
import java.util.LinkedHashMap;
import junit.framework.TestCase;

public class FOLSubstTest
extends TestCase {
    private FOLParser parser;
    private SubstVisitor sv;

    public void setUp() {
        this.parser = new FOLParser(DomainFactory.crusadesDomain());
        this.sv = new SubstVisitor();
    }

    public void testSubstSingleVariableSucceedsWithPredicate() {
        Sentence sentence = this.parser.parse("King(x)");
        Sentence sentence2 = this.parser.parse(" King(John) ");
        Sentence sentence3 = sentence2.copy();
        FOLSubstTest.assertEquals((Object)sentence2, (Object)sentence3);
        LinkedHashMap<Variable, Term> linkedHashMap = new LinkedHashMap<Variable, Term>();
        linkedHashMap.put(new Variable("x"), new Constant("John"));
        Sentence sentence4 = this.sv.subst(linkedHashMap, sentence);
        FOLSubstTest.assertEquals((Object)sentence2, (Object)sentence4);
        FOLSubstTest.assertEquals((Object)sentence, (Object)this.parser.parse("King(x)"));
    }

    public void testSubstSingleVariableFailsWithPredicate() {
        Sentence sentence = this.parser.parse("King(x)");
        Sentence sentence2 = this.parser.parse(" King(x) ");
        LinkedHashMap<Variable, Term> linkedHashMap = new LinkedHashMap<Variable, Term>();
        linkedHashMap.put(new Variable("y"), new Constant("John"));
        Sentence sentence3 = this.sv.subst(linkedHashMap, sentence);
        FOLSubstTest.assertEquals((Object)sentence2, (Object)sentence3);
        FOLSubstTest.assertEquals((Object)sentence, (Object)this.parser.parse("King(x)"));
    }

    public void testMultipleVariableSubstitutionWithPredicate() {
        Sentence sentence = this.parser.parse("King(x,y)");
        Sentence sentence2 = this.parser.parse(" King(John ,England) ");
        LinkedHashMap<Variable, Term> linkedHashMap = new LinkedHashMap<Variable, Term>();
        linkedHashMap.put(new Variable("x"), new Constant("John"));
        linkedHashMap.put(new Variable("y"), new Constant("England"));
        Sentence sentence3 = this.sv.subst(linkedHashMap, sentence);
        FOLSubstTest.assertEquals((Object)sentence2, (Object)sentence3);
        FOLSubstTest.assertEquals((Object)sentence, (Object)this.parser.parse("King(x,y)"));
    }

    public void testMultipleVariablePartiallySucceedsWithPredicate() {
        Sentence sentence = this.parser.parse("King(x,y)");
        Sentence sentence2 = this.parser.parse(" King(John ,y) ");
        LinkedHashMap<Variable, Term> linkedHashMap = new LinkedHashMap<Variable, Term>();
        linkedHashMap.put(new Variable("x"), new Constant("John"));
        linkedHashMap.put(new Variable("z"), new Constant("England"));
        Sentence sentence3 = this.sv.subst(linkedHashMap, sentence);
        FOLSubstTest.assertEquals((Object)sentence2, (Object)sentence3);
        FOLSubstTest.assertEquals((Object)sentence, (Object)this.parser.parse("King(x,y)"));
    }

    public void testSubstSingleVariableSucceedsWithTermEquality() {
        Sentence sentence = this.parser.parse("BrotherOf(x) = EnemyOf(y)");
        Sentence sentence2 = this.parser.parse("BrotherOf(John) = EnemyOf(Saladin)");
        LinkedHashMap<Variable, Term> linkedHashMap = new LinkedHashMap<Variable, Term>();
        linkedHashMap.put(new Variable("x"), new Constant("John"));
        linkedHashMap.put(new Variable("y"), new Constant("Saladin"));
        Sentence sentence3 = this.sv.subst(linkedHashMap, sentence);
        FOLSubstTest.assertEquals((Object)sentence2, (Object)sentence3);
        FOLSubstTest.assertEquals((Object)sentence, (Object)this.parser.parse("BrotherOf(x) = EnemyOf(y)"));
    }

    public void testSubstSingleVariableSucceedsWithTermEquality2() {
        Sentence sentence = this.parser.parse("BrotherOf(John) = x)");
        Sentence sentence2 = this.parser.parse("BrotherOf(John) = Richard");
        LinkedHashMap<Variable, Term> linkedHashMap = new LinkedHashMap<Variable, Term>();
        linkedHashMap.put(new Variable("x"), new Constant("Richard"));
        linkedHashMap.put(new Variable("y"), new Constant("Saladin"));
        Sentence sentence3 = this.sv.subst(linkedHashMap, sentence);
        FOLSubstTest.assertEquals((Object)sentence2, (Object)sentence3);
        FOLSubstTest.assertEquals((Object)this.parser.parse("BrotherOf(John) = x)"), (Object)sentence);
    }

    public void testSubstWithUniversalQuantifierAndSngleVariable() {
        Sentence sentence = this.parser.parse("FORALL x King(x))");
        Sentence sentence2 = this.parser.parse("King(John)");
        LinkedHashMap<Variable, Term> linkedHashMap = new LinkedHashMap<Variable, Term>();
        linkedHashMap.put(new Variable("x"), new Constant("John"));
        Sentence sentence3 = this.sv.subst(linkedHashMap, sentence);
        FOLSubstTest.assertEquals((Object)sentence2, (Object)sentence3);
        FOLSubstTest.assertEquals((Object)this.parser.parse("FORALL x King(x))"), (Object)sentence);
    }

    public void testSubstWithUniversalQuantifierAndZeroVariablesMatched() {
        Sentence sentence = this.parser.parse("FORALL x King(x))");
        Sentence sentence2 = this.parser.parse("FORALL x King(x)");
        LinkedHashMap<Variable, Term> linkedHashMap = new LinkedHashMap<Variable, Term>();
        linkedHashMap.put(new Variable("y"), new Constant("John"));
        Sentence sentence3 = this.sv.subst(linkedHashMap, sentence);
        FOLSubstTest.assertEquals((Object)sentence2, (Object)sentence3);
        FOLSubstTest.assertEquals((Object)this.parser.parse("FORALL x King(x))"), (Object)sentence);
    }

    public void testSubstWithUniversalQuantifierAndOneOfTwoVariablesMatched() {
        Sentence sentence = this.parser.parse("FORALL x,y King(x,y))");
        Sentence sentence2 = this.parser.parse("FORALL x King(x,John)");
        LinkedHashMap<Variable, Term> linkedHashMap = new LinkedHashMap<Variable, Term>();
        linkedHashMap.put(new Variable("y"), new Constant("John"));
        Sentence sentence3 = this.sv.subst(linkedHashMap, sentence);
        FOLSubstTest.assertEquals((Object)sentence2, (Object)sentence3);
        FOLSubstTest.assertEquals((Object)this.parser.parse("FORALL x,y King(x,y))"), (Object)sentence);
    }

    public void testSubstWithExistentialQuantifierAndSngleVariable() {
        Sentence sentence = this.parser.parse("EXISTS x King(x))");
        Sentence sentence2 = this.parser.parse("King(John)");
        LinkedHashMap<Variable, Term> linkedHashMap = new LinkedHashMap<Variable, Term>();
        linkedHashMap.put(new Variable("x"), new Constant("John"));
        Sentence sentence3 = this.sv.subst(linkedHashMap, sentence);
        FOLSubstTest.assertEquals((Object)sentence2, (Object)sentence3);
        FOLSubstTest.assertEquals((Object)this.parser.parse("EXISTS x King(x)"), (Object)sentence);
    }

    public void testSubstWithNOTSentenceAndSngleVariable() {
        Sentence sentence = this.parser.parse("NOT King(x))");
        Sentence sentence2 = this.parser.parse("NOT King(John)");
        LinkedHashMap<Variable, Term> linkedHashMap = new LinkedHashMap<Variable, Term>();
        linkedHashMap.put(new Variable("x"), new Constant("John"));
        Sentence sentence3 = this.sv.subst(linkedHashMap, sentence);
        FOLSubstTest.assertEquals((Object)sentence2, (Object)sentence3);
        FOLSubstTest.assertEquals((Object)this.parser.parse("NOT King(x))"), (Object)sentence);
    }

    public void testConnectiveANDSentenceAndSngleVariable() {
        Sentence sentence = this.parser.parse("EXISTS x ( King(x) AND BrotherOf(x) = EnemyOf(y) )");
        Sentence sentence2 = this.parser.parse("( King(John) AND BrotherOf(John) = EnemyOf(Saladin) )");
        LinkedHashMap<Variable, Term> linkedHashMap = new LinkedHashMap<Variable, Term>();
        linkedHashMap.put(new Variable("x"), new Constant("John"));
        linkedHashMap.put(new Variable("y"), new Constant("Saladin"));
        Sentence sentence3 = this.sv.subst(linkedHashMap, sentence);
        FOLSubstTest.assertEquals((Object)sentence2, (Object)sentence3);
        FOLSubstTest.assertEquals((Object)this.parser.parse("EXISTS x ( King(x) AND BrotherOf(x) = EnemyOf(y) )"), (Object)sentence);
    }

    public void testParanthisedSingleVariable() {
        Sentence sentence = this.parser.parse("((( King(x))))");
        Sentence sentence2 = this.parser.parse("King(John) ");
        LinkedHashMap<Variable, Term> linkedHashMap = new LinkedHashMap<Variable, Term>();
        linkedHashMap.put(new Variable("x"), new Constant("John"));
        Sentence sentence3 = this.sv.subst(linkedHashMap, sentence);
        FOLSubstTest.assertEquals((Object)sentence2, (Object)sentence3);
        FOLSubstTest.assertEquals((Object)this.parser.parse("((( King(x))))"), (Object)sentence);
    }
}

