/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.fol.domain.FOLDomain;
import aima.logic.fol.inference.Paramodulation;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.parsing.FOLParser;
import aima.logic.fol.parsing.ast.AtomicSentence;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import junit.framework.TestCase;

public class ParamodulationTest
extends TestCase {
    private Paramodulation paramodulation = null;

    public void setUp() {
        this.paramodulation = new Paramodulation();
    }

    public void testSimpleExample() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addConstant("A");
        fOLDomain.addConstant("B");
        fOLDomain.addPredicate("P");
        fOLDomain.addPredicate("Q");
        fOLDomain.addPredicate("R");
        fOLDomain.addFunction("F");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        ArrayList<Literal> arrayList = new ArrayList<Literal>();
        AtomicSentence atomicSentence = (AtomicSentence)fOLParser.parse("P(F(x,B),x)");
        AtomicSentence atomicSentence2 = (AtomicSentence)fOLParser.parse("Q(x)");
        arrayList.add(new Literal(atomicSentence));
        arrayList.add(new Literal(atomicSentence2));
        Clause clause = new Clause(arrayList);
        arrayList.clear();
        atomicSentence = (AtomicSentence)fOLParser.parse("F(A,y) = y");
        atomicSentence2 = (AtomicSentence)fOLParser.parse("R(y)");
        arrayList.add(new Literal(atomicSentence));
        arrayList.add(new Literal(atomicSentence2));
        Clause clause2 = new Clause(arrayList);
        Set<Clause> set = this.paramodulation.apply(clause, clause2);
        ParamodulationTest.assertEquals((int)2, (int)set.size());
        Iterator<Clause> iterator = set.iterator();
        ParamodulationTest.assertEquals((String)"[P(B,A), Q(A), R(B)]", (String)iterator.next().toString());
        ParamodulationTest.assertEquals((String)"[P(F(A,F(x,B)),x), Q(x), R(F(x,B))]", (String)iterator.next().toString());
    }

    public void testMultipleTermEqualitiesInBothClausesExample() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addConstant("A");
        fOLDomain.addConstant("B");
        fOLDomain.addConstant("C");
        fOLDomain.addConstant("D");
        fOLDomain.addPredicate("P");
        fOLDomain.addPredicate("Q");
        fOLDomain.addPredicate("R");
        fOLDomain.addFunction("F");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        ArrayList<Literal> arrayList = new ArrayList<Literal>();
        AtomicSentence atomicSentence = (AtomicSentence)fOLParser.parse("F(C,x) = D");
        AtomicSentence atomicSentence2 = (AtomicSentence)fOLParser.parse("A = D");
        AtomicSentence atomicSentence3 = (AtomicSentence)fOLParser.parse("P(F(x,B),x)");
        AtomicSentence atomicSentence4 = (AtomicSentence)fOLParser.parse("Q(x)");
        AtomicSentence atomicSentence5 = (AtomicSentence)fOLParser.parse("R(C)");
        arrayList.add(new Literal(atomicSentence));
        arrayList.add(new Literal(atomicSentence2));
        arrayList.add(new Literal(atomicSentence3));
        arrayList.add(new Literal(atomicSentence4));
        arrayList.add(new Literal(atomicSentence5));
        Clause clause = new Clause(arrayList);
        arrayList.clear();
        atomicSentence = (AtomicSentence)fOLParser.parse("F(A,y) = y");
        atomicSentence2 = (AtomicSentence)fOLParser.parse("F(B,y) = C");
        atomicSentence3 = (AtomicSentence)fOLParser.parse("R(y)");
        atomicSentence4 = (AtomicSentence)fOLParser.parse("R(A)");
        arrayList.add(new Literal(atomicSentence));
        arrayList.add(new Literal(atomicSentence2));
        arrayList.add(new Literal(atomicSentence3));
        arrayList.add(new Literal(atomicSentence4));
        Clause clause2 = new Clause(arrayList);
        Set<Clause> set = this.paramodulation.apply(clause, clause2);
        ParamodulationTest.assertEquals((int)5, (int)set.size());
        Iterator<Clause> iterator = set.iterator();
        ParamodulationTest.assertEquals((String)"[F(B,B) = C, F(C,A) = D, A = D, P(B,A), Q(A), R(A), R(B), R(C)]", (String)iterator.next().toString());
        ParamodulationTest.assertEquals((String)"[F(A,F(C,x)) = D, F(B,F(C,x)) = C, A = D, P(F(x,B),x), Q(x), R(F(C,x)), R(A), R(C)]", (String)iterator.next().toString());
        ParamodulationTest.assertEquals((String)"[F(A,B) = B, F(C,B) = D, A = D, P(C,B), Q(B), R(A), R(B), R(C)]", (String)iterator.next().toString());
        ParamodulationTest.assertEquals((String)"[F(F(B,y),x) = D, F(A,y) = y, A = D, P(F(x,B),x), Q(x), R(y), R(A), R(C)]", (String)iterator.next().toString());
        ParamodulationTest.assertEquals((String)"[F(B,y) = C, F(C,x) = D, F(D,y) = y, P(F(x,B),x), Q(x), R(y), R(A), R(C)]", (String)iterator.next().toString());
    }

    public void testBypassReflexivityAxiom() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addConstant("A");
        fOLDomain.addConstant("B");
        fOLDomain.addConstant("C");
        fOLDomain.addPredicate("P");
        fOLDomain.addFunction("F");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        ArrayList<Literal> arrayList = new ArrayList<Literal>();
        AtomicSentence atomicSentence = (AtomicSentence)fOLParser.parse("P(y, F(A,y))");
        arrayList.add(new Literal(atomicSentence));
        Clause clause = new Clause(arrayList);
        arrayList.clear();
        atomicSentence = (AtomicSentence)fOLParser.parse("x = x");
        arrayList.add(new Literal(atomicSentence));
        Clause clause2 = new Clause(arrayList);
        Set<Clause> set = this.paramodulation.apply(clause, clause2);
        ParamodulationTest.assertEquals((int)0, (int)set.size());
    }

    public void testNegativeTermEquality() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addConstant("A");
        fOLDomain.addConstant("B");
        fOLDomain.addConstant("C");
        fOLDomain.addPredicate("P");
        fOLDomain.addFunction("F");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        ArrayList<Literal> arrayList = new ArrayList<Literal>();
        AtomicSentence atomicSentence = (AtomicSentence)fOLParser.parse("P(y, F(A,y))");
        arrayList.add(new Literal(atomicSentence));
        Clause clause = new Clause(arrayList);
        arrayList.clear();
        atomicSentence = (AtomicSentence)fOLParser.parse("F(x,B) = x");
        arrayList.add(new Literal(atomicSentence, true));
        Clause clause2 = new Clause(arrayList);
        Set<Clause> set = this.paramodulation.apply(clause, clause2);
        ParamodulationTest.assertEquals((int)0, (int)set.size());
    }
}

