/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.fol.CNFConverter;
import aima.logic.fol.SubsumptionElimination;
import aima.logic.fol.domain.FOLDomain;
import aima.logic.fol.kb.data.CNF;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.parsing.FOLParser;
import aima.logic.fol.parsing.ast.Sentence;
import java.util.HashSet;
import junit.framework.TestCase;

public class SubsumptionEliminationTest
extends TestCase {
    public void testFindSubsumedClauses() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addPredicate("patrons");
        fOLDomain.addPredicate("hungry");
        fOLDomain.addPredicate("type");
        fOLDomain.addPredicate("fri_sat");
        fOLDomain.addPredicate("will_wait");
        fOLDomain.addConstant("Some");
        fOLDomain.addConstant("Full");
        fOLDomain.addConstant("French");
        fOLDomain.addConstant("Thai");
        fOLDomain.addConstant("Burger");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        String string = "patrons(v,Some)";
        String string2 = "patrons(v,Full) AND (hungry(v) AND type(v,French))";
        String string3 = "patrons(v,Full) AND (hungry(v) AND (type(v,Thai) AND fri_sat(v)))";
        String string4 = "patrons(v,Full) AND (hungry(v) AND type(v,Burger))";
        String string5 = "FORALL v (will_wait(v) <=> (" + string + " OR (" + string2 + " OR (" + string3 + " OR (" + string4 + ")))))";
        Sentence sentence = fOLParser.parse(string5);
        CNFConverter cNFConverter = new CNFConverter(fOLParser);
        CNF cNF = cNFConverter.convertToCNF(sentence);
        SubsumptionEliminationTest.assertEquals((int)40, (int)cNF.getNumberOfClauses());
        HashSet<Clause> hashSet = new HashSet<Clause>(cNF.getConjunctionOfClauses());
        SubsumptionEliminationTest.assertEquals((int)31, (int)hashSet.size());
        hashSet.removeAll(SubsumptionElimination.findSubsumedClauses(hashSet));
        SubsumptionEliminationTest.assertEquals((int)8, (int)hashSet.size());
        Clause clause = cNFConverter.convertToCNF(fOLParser.parse("(NOT(will_wait(v)) OR (patrons(v,Full) OR patrons(v,Some)))")).getConjunctionOfClauses().get(0);
        Clause clause2 = cNFConverter.convertToCNF(fOLParser.parse("(NOT(will_wait(v)) OR (hungry(v) OR patrons(v,Some)))")).getConjunctionOfClauses().get(0);
        Clause clause3 = cNFConverter.convertToCNF(fOLParser.parse("(NOT(will_wait(v)) OR (patrons(v,Some) OR (type(v,Burger) OR (type(v,French) OR type(v,Thai)))))")).getConjunctionOfClauses().get(0);
        Clause clause4 = cNFConverter.convertToCNF(fOLParser.parse("(NOT(will_wait(v)) OR (fri_sat(v) OR (patrons(v,Some) OR (type(v,Burger) OR type(v,French)))))")).getConjunctionOfClauses().get(0);
        Clause clause5 = cNFConverter.convertToCNF(fOLParser.parse("(NOT(patrons(v,Some)) OR will_wait(v))")).getConjunctionOfClauses().get(0);
        Clause clause6 = cNFConverter.convertToCNF(fOLParser.parse("(NOT(hungry(v)) OR (NOT(patrons(v,Full)) OR (NOT(type(v,French)) OR will_wait(v))))")).getConjunctionOfClauses().get(0);
        Clause clause7 = cNFConverter.convertToCNF(fOLParser.parse("(NOT(fri_sat(v)) OR (NOT(hungry(v)) OR (NOT(patrons(v,Full)) OR (NOT(type(v,Thai)) OR will_wait(v)))))")).getConjunctionOfClauses().get(0);
        Clause clause8 = cNFConverter.convertToCNF(fOLParser.parse("(NOT(hungry(v)) OR (NOT(patrons(v,Full)) OR (NOT(type(v,Burger)) OR will_wait(v))))")).getConjunctionOfClauses().get(0);
        SubsumptionEliminationTest.assertTrue((boolean)hashSet.contains(clause));
        SubsumptionEliminationTest.assertTrue((boolean)hashSet.contains(clause2));
        SubsumptionEliminationTest.assertTrue((boolean)hashSet.contains(clause3));
        SubsumptionEliminationTest.assertTrue((boolean)hashSet.contains(clause4));
        SubsumptionEliminationTest.assertTrue((boolean)hashSet.contains(clause5));
        SubsumptionEliminationTest.assertTrue((boolean)hashSet.contains(clause6));
        SubsumptionEliminationTest.assertTrue((boolean)hashSet.contains(clause7));
        SubsumptionEliminationTest.assertTrue((boolean)hashSet.contains(clause8));
    }
}

