/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.fol.Unifier;
import aima.logic.fol.domain.DomainFactory;
import aima.logic.fol.domain.FOLDomain;
import aima.logic.fol.parsing.FOLParser;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import junit.framework.TestCase;

public class UnifierTest
extends TestCase {
    private FOLParser parser;
    private Unifier unifier;
    private Map<Variable, Term> theta;

    public void setUp() {
        this.parser = new FOLParser(DomainFactory.knowsDomain());
        this.unifier = new Unifier();
        this.theta = new Hashtable<Variable, Term>();
    }

    public void testFailureIfThetaisNull() {
        Variable variable = new Variable("x");
        Sentence sentence = this.parser.parse("Knows(x)");
        this.theta = null;
        Map<Variable, Term> map = this.unifier.unify(variable, sentence, this.theta);
        UnifierTest.assertNull(map);
    }

    public void testUnificationFailure() {
        Variable variable = new Variable("x");
        Sentence sentence = this.parser.parse("Knows(y)");
        this.theta = null;
        Map<Variable, Term> map = this.unifier.unify(variable, sentence, this.theta);
        UnifierTest.assertNull(map);
    }

    public void testThetaPassedBackIfXEqualsYBothVariables() {
        Variable variable = new Variable("x");
        Variable variable2 = new Variable("x");
        this.theta.put(new Variable("dummy"), new Variable("dummy"));
        Map<Variable, Term> map = this.unifier.unify(variable, variable2, this.theta);
        UnifierTest.assertEquals(this.theta, map);
        UnifierTest.assertEquals((int)1, (int)this.theta.keySet().size());
        UnifierTest.assertTrue((boolean)this.theta.containsKey(new Variable("dummy")));
    }

    public void testVariableEqualsConstant() {
        Variable variable = new Variable("x");
        Constant constant = new Constant("John");
        Map<Variable, Term> map = this.unifier.unify(variable, constant, this.theta);
        UnifierTest.assertEquals(this.theta, map);
        UnifierTest.assertEquals((int)1, (int)this.theta.keySet().size());
        UnifierTest.assertTrue((boolean)this.theta.keySet().contains(variable));
        UnifierTest.assertEquals((Object)constant, (Object)this.theta.get(variable));
    }

    public void testSimpleVariableUnification() {
        Variable variable = new Variable("x");
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(variable);
        Predicate predicate = new Predicate("King", arrayList);
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        arrayList2.add(new Constant("John"));
        Predicate predicate2 = new Predicate("King", arrayList2);
        Map<Variable, Term> map = this.unifier.unify(predicate, predicate2, this.theta);
        UnifierTest.assertEquals(this.theta, map);
        UnifierTest.assertEquals((int)1, (int)this.theta.keySet().size());
        UnifierTest.assertTrue((boolean)this.theta.keySet().contains(new Variable("x")));
        UnifierTest.assertEquals((Object)new Constant("John"), (Object)this.theta.get(variable));
    }

    public void testKnows1() {
        Sentence sentence = this.parser.parse("Knows(John,x)");
        Sentence sentence2 = this.parser.parse("Knows(John,Jane)");
        Map<Variable, Term> map = this.unifier.unify(sentence, sentence2, this.theta);
        UnifierTest.assertEquals(this.theta, map);
        UnifierTest.assertTrue((boolean)this.theta.keySet().contains(new Variable("x")));
        UnifierTest.assertEquals((Object)new Constant("Jane"), (Object)this.theta.get(new Variable("x")));
    }

    public void testKnows2() {
        Sentence sentence = this.parser.parse("Knows(John,x)");
        Sentence sentence2 = this.parser.parse("Knows(y,Bill)");
        Map<Variable, Term> map = this.unifier.unify(sentence, sentence2, this.theta);
        UnifierTest.assertEquals((int)2, (int)map.size());
        UnifierTest.assertEquals((Object)new Constant("Bill"), (Object)this.theta.get(new Variable("x")));
        UnifierTest.assertEquals((Object)new Constant("John"), (Object)this.theta.get(new Variable("y")));
    }

    public void testKnows3() {
        Sentence sentence = this.parser.parse("Knows(John,x)");
        Sentence sentence2 = this.parser.parse("Knows(y,Mother(y))");
        Map<Variable, Term> map = this.unifier.unify(sentence, sentence2, this.theta);
        UnifierTest.assertEquals((int)2, (int)map.size());
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(new Constant("John"));
        Function function = new Function("Mother", arrayList);
        UnifierTest.assertEquals((Object)function, (Object)this.theta.get(new Variable("x")));
        UnifierTest.assertEquals((Object)new Constant("John"), (Object)this.theta.get(new Variable("y")));
    }

    public void testKnows5() {
        Sentence sentence = this.parser.parse("Knows(John,x)");
        Sentence sentence2 = this.parser.parse("Knows(y,z)");
        Map<Variable, Term> map = this.unifier.unify(sentence, sentence2, this.theta);
        UnifierTest.assertEquals((int)2, (int)map.size());
        UnifierTest.assertEquals((Object)new Variable("z"), (Object)this.theta.get(new Variable("x")));
        UnifierTest.assertEquals((Object)new Constant("John"), (Object)this.theta.get(new Variable("y")));
    }

    public void testCascadedOccursCheck() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addPredicate("P");
        fOLDomain.addFunction("F");
        fOLDomain.addFunction("SF0");
        fOLDomain.addFunction("SF1");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        Sentence sentence = fOLParser.parse("P(SF1(v2),v2)");
        Sentence sentence2 = fOLParser.parse("P(v3,SF0(v3))");
        Map<Variable, Term> map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNull(map);
        sentence = fOLParser.parse("P(v1,SF0(v1),SF0(v1),SF0(v1),SF0(v1))");
        sentence2 = fOLParser.parse("P(v2,SF0(v2),v2,     v3,     v2)");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNull(map);
        sentence = fOLParser.parse("P(v1,   F(v2),F(v2),F(v2),v1,      F(F(v1)),F(F(F(v1))),v2)");
        sentence2 = fOLParser.parse("P(F(v3),v4,   v5,   v6,   F(F(v5)),v4,      F(v3),      F(F(v5)))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNull(map);
    }

    public void testAdditionalVariableMixtures() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addConstant("A");
        fOLDomain.addConstant("B");
        fOLDomain.addFunction("F");
        fOLDomain.addFunction("G");
        fOLDomain.addFunction("H");
        fOLDomain.addPredicate("P");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        Sentence sentence = fOLParser.parse("P(z, x)");
        Sentence sentence2 = fOLParser.parse("P(x, a)");
        Map<Variable, Term> map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertEquals((String)"{z=a, x=a}", (String)map.toString());
        sentence = fOLParser.parse("P(x, z)");
        sentence2 = fOLParser.parse("P(a, x)");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertEquals((String)"{x=a, z=a}", (String)map.toString());
        sentence = fOLParser.parse("P(w, w, w)");
        sentence2 = fOLParser.parse("P(x, y, z)");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertEquals((String)"{w=z, x=z, y=z}", (String)map.toString());
        sentence = fOLParser.parse("P(x, y, z)");
        sentence2 = fOLParser.parse("P(w, w, w)");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertEquals((String)"{x=w, y=w, z=w}", (String)map.toString());
        sentence = fOLParser.parse("P(x, B, F(y))");
        sentence2 = fOLParser.parse("P(A, y, F(z))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertEquals((String)"{x=A, y=B, z=B}", (String)map.toString());
        sentence = fOLParser.parse("P(F(x,B), G(y),         F(z,A))");
        sentence2 = fOLParser.parse("P(y,      G(F(G(w),w)), F(w,z))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNull(map);
        sentence = fOLParser.parse("P(F(G(A)), x,    F(H(z,z)), H(y,    G(w)))");
        sentence2 = fOLParser.parse("P(y,       G(z), F(v     ), H(F(w), x   ))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertEquals((String)"{y=F(G(A)), x=G(G(A)), v=H(G(A),G(A)), w=G(A), z=G(A)}", (String)map.toString());
    }

    public void testTermEquality() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addConstant("A");
        fOLDomain.addConstant("B");
        fOLDomain.addFunction("Plus");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        TermEquality termEquality = (TermEquality)fOLParser.parse("x = x");
        TermEquality termEquality2 = (TermEquality)fOLParser.parse("x = x");
        Map<Variable, Term> map = this.unifier.unify(termEquality, termEquality2);
        UnifierTest.assertNotNull(map);
        UnifierTest.assertEquals((int)0, (int)map.size());
        termEquality = (TermEquality)fOLParser.parse("x1 = x1");
        termEquality2 = (TermEquality)fOLParser.parse("x2 = x2");
        map = this.unifier.unify(termEquality, termEquality2);
        UnifierTest.assertNotNull(map);
        UnifierTest.assertEquals((int)1, (int)map.size());
        UnifierTest.assertEquals((String)"{x1=x2}", (String)map.toString());
        termEquality = (TermEquality)fOLParser.parse("x1 = x1");
        termEquality2 = (TermEquality)fOLParser.parse("Plus(A,B) = Plus(A,B)");
        map = this.unifier.unify(termEquality, termEquality2);
        UnifierTest.assertNotNull(map);
        UnifierTest.assertEquals((int)1, (int)map.size());
        UnifierTest.assertEquals((String)"{x1=Plus(A,B)}", (String)map.toString());
        termEquality = (TermEquality)fOLParser.parse("x1 = x1");
        termEquality2 = (TermEquality)fOLParser.parse("Plus(A,B) = Plus(A,z1)");
        map = this.unifier.unify(termEquality, termEquality2);
        UnifierTest.assertNotNull(map);
        UnifierTest.assertEquals((int)2, (int)map.size());
        UnifierTest.assertEquals((String)"{x1=Plus(A,B), z1=B}", (String)map.toString());
        termEquality = (TermEquality)fOLParser.parse("x1 = x1");
        termEquality2 = (TermEquality)fOLParser.parse("Plus(A,z1) = Plus(A,B)");
        map = this.unifier.unify(termEquality, termEquality2);
        UnifierTest.assertNotNull(map);
        UnifierTest.assertEquals((int)2, (int)map.size());
        UnifierTest.assertEquals((String)"{x1=Plus(A,B), z1=B}", (String)map.toString());
        termEquality = (TermEquality)fOLParser.parse("Plus(Plus(Plus(A,B),B, A)) = Plus(Plus(Plus(A,B),B, A))");
        termEquality2 = (TermEquality)fOLParser.parse("Plus(Plus(Plus(A,B),B, A)) = Plus(Plus(Plus(A,B),B, A))");
        map = this.unifier.unify(termEquality, termEquality2);
        UnifierTest.assertNotNull(map);
        UnifierTest.assertEquals((int)0, (int)map.size());
        termEquality = (TermEquality)fOLParser.parse("Plus(A,B) = Plus(B,A)");
        termEquality2 = (TermEquality)fOLParser.parse("Plus(A,B) = Plus(A,B)");
        map = this.unifier.unify(termEquality, termEquality2);
        UnifierTest.assertNull(map);
    }

    public void testNOTSentence() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addConstant("A");
        fOLDomain.addConstant("B");
        fOLDomain.addConstant("C");
        fOLDomain.addFunction("Plus");
        fOLDomain.addPredicate("P");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        Sentence sentence = fOLParser.parse("NOT(P(A))");
        Sentence sentence2 = fOLParser.parse("NOT(P(A))");
        Map<Variable, Term> map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNotNull(map);
        UnifierTest.assertEquals((int)0, (int)map.size());
        sentence = fOLParser.parse("NOT(P(A))");
        sentence2 = fOLParser.parse("NOT(P(B))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNull(map);
        sentence = fOLParser.parse("NOT(P(A))");
        sentence2 = fOLParser.parse("NOT(P(x))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNotNull(map);
        UnifierTest.assertEquals((int)1, (int)map.size());
        UnifierTest.assertEquals((Object)new Constant("A"), (Object)map.get(new Variable("x")));
    }

    public void testConnectedSentence() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addConstant("A");
        fOLDomain.addConstant("B");
        fOLDomain.addConstant("C");
        fOLDomain.addFunction("Plus");
        fOLDomain.addPredicate("P");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        Sentence sentence = fOLParser.parse("(P(A) AND P(B))");
        Sentence sentence2 = fOLParser.parse("(P(A) AND P(B))");
        Map<Variable, Term> map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNotNull(map);
        UnifierTest.assertEquals((int)0, (int)map.size());
        sentence = fOLParser.parse("(P(A) AND P(B))");
        sentence2 = fOLParser.parse("(P(A) AND P(C))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNull(map);
        sentence = fOLParser.parse("(P(A) AND P(B))");
        sentence2 = fOLParser.parse("(P(A) AND P(x))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNotNull(map);
        UnifierTest.assertEquals((int)1, (int)map.size());
        UnifierTest.assertEquals((Object)new Constant("B"), (Object)map.get(new Variable("x")));
        sentence = fOLParser.parse("(P(A) OR P(B))");
        sentence2 = fOLParser.parse("(P(A) OR P(B))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNotNull(map);
        UnifierTest.assertEquals((int)0, (int)map.size());
        sentence = fOLParser.parse("(P(A) OR P(B))");
        sentence2 = fOLParser.parse("(P(A) OR P(C))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNull(map);
        sentence = fOLParser.parse("(P(A) OR P(B))");
        sentence2 = fOLParser.parse("(P(A) OR P(x))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNotNull(map);
        UnifierTest.assertEquals((int)1, (int)map.size());
        UnifierTest.assertEquals((Object)new Constant("B"), (Object)map.get(new Variable("x")));
        sentence = fOLParser.parse("(P(A) => P(B))");
        sentence2 = fOLParser.parse("(P(A) => P(B))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNotNull(map);
        UnifierTest.assertEquals((int)0, (int)map.size());
        sentence = fOLParser.parse("(P(A) => P(B))");
        sentence2 = fOLParser.parse("(P(A) => P(C))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNull(map);
        sentence = fOLParser.parse("(P(A) => P(B))");
        sentence2 = fOLParser.parse("(P(A) => P(x))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNotNull(map);
        UnifierTest.assertEquals((int)1, (int)map.size());
        UnifierTest.assertEquals((Object)new Constant("B"), (Object)map.get(new Variable("x")));
        sentence = fOLParser.parse("(P(A) <=> P(B))");
        sentence2 = fOLParser.parse("(P(A) <=> P(B))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNotNull(map);
        UnifierTest.assertEquals((int)0, (int)map.size());
        sentence = fOLParser.parse("(P(A) <=> P(B))");
        sentence2 = fOLParser.parse("(P(A) <=> P(C))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNull(map);
        sentence = fOLParser.parse("(P(A) <=> P(B))");
        sentence2 = fOLParser.parse("(P(A) <=> P(x))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNotNull(map);
        UnifierTest.assertEquals((int)1, (int)map.size());
        UnifierTest.assertEquals((Object)new Constant("B"), (Object)map.get(new Variable("x")));
        sentence = fOLParser.parse("((P(A) AND P(B)) OR (P(C) => (P(A) <=> P(C))))");
        sentence2 = fOLParser.parse("((P(A) AND P(B)) OR (P(C) => (P(A) <=> P(C))))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNotNull(map);
        UnifierTest.assertEquals((int)0, (int)map.size());
        sentence = fOLParser.parse("((P(A) AND P(B)) OR (P(C) => (P(A) <=> P(C))))");
        sentence2 = fOLParser.parse("((P(A) AND P(B)) OR (P(C) => (P(A) <=> P(A))))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNull(map);
        sentence = fOLParser.parse("((P(A) AND P(B)) OR (P(C) => (P(A) <=> P(C))))");
        sentence2 = fOLParser.parse("((P(A) AND P(B)) OR (P(C) => (P(A) <=> P(x))))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNotNull(map);
        UnifierTest.assertEquals((int)1, (int)map.size());
        UnifierTest.assertEquals((Object)new Constant("C"), (Object)map.get(new Variable("x")));
    }

    public void testQuantifiedSentence() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addConstant("A");
        fOLDomain.addConstant("B");
        fOLDomain.addConstant("C");
        fOLDomain.addFunction("Plus");
        fOLDomain.addPredicate("P");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        Sentence sentence = fOLParser.parse("FORALL x,y ((P(x) AND P(A)) OR (P(A) => P(y)))");
        Sentence sentence2 = fOLParser.parse("FORALL x,y ((P(x) AND P(A)) OR (P(A) => P(y)))");
        Map<Variable, Term> map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNotNull(map);
        UnifierTest.assertEquals((int)0, (int)map.size());
        sentence = fOLParser.parse("FORALL x,y ((P(x) AND P(A)) OR (P(A) => P(y)))");
        sentence2 = fOLParser.parse("FORALL x   ((P(x) AND P(A)) OR (P(A) => P(y)))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNull(map);
        sentence = fOLParser.parse("FORALL x,y ((P(x) AND P(A)) OR (P(A) => P(y)))");
        sentence2 = fOLParser.parse("FORALL x,y ((P(x) AND P(A)) OR (P(B) => P(y)))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNull(map);
        sentence = fOLParser.parse("FORALL x,y ((P(x) AND P(A)) OR (P(A) => P(y)))");
        sentence2 = fOLParser.parse("FORALL x,y ((P(A) AND P(A)) OR (P(A) => P(y)))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNotNull(map);
        UnifierTest.assertEquals((int)1, (int)map.size());
        UnifierTest.assertEquals((Object)new Constant("A"), (Object)map.get(new Variable("x")));
        sentence = fOLParser.parse("EXISTS x,y ((P(x) AND P(A)) OR (P(A) => P(y)))");
        sentence2 = fOLParser.parse("EXISTS x,y ((P(x) AND P(A)) OR (P(A) => P(y)))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNotNull(map);
        UnifierTest.assertEquals((int)0, (int)map.size());
        sentence = fOLParser.parse("EXISTS x,y ((P(x) AND P(A)) OR (P(A) => P(y)))");
        sentence2 = fOLParser.parse("EXISTS x   ((P(x) AND P(A)) OR (P(A) => P(y)))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNull(map);
        sentence = fOLParser.parse("EXISTS x,y ((P(x) AND P(A)) OR (P(A) => P(y)))");
        sentence2 = fOLParser.parse("EXISTS x,y ((P(x) AND P(A)) OR (P(B) => P(y)))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNull(map);
        sentence = fOLParser.parse("EXISTS x,y ((P(x) AND P(A)) OR (P(A) => P(y)))");
        sentence2 = fOLParser.parse("EXISTS x,y ((P(A) AND P(A)) OR (P(A) => P(y)))");
        map = this.unifier.unify(sentence, sentence2);
        UnifierTest.assertNotNull(map);
        UnifierTest.assertEquals((int)1, (int)map.size());
        UnifierTest.assertEquals((Object)new Constant("A"), (Object)map.get(new Variable("x")));
    }
}

