/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.prop.algorithms;

import aima.logic.propositional.algorithms.Model;
import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import junit.framework.TestCase;

public class ModelTest
extends TestCase {
    private Model m;
    private PEParser parser;
    Sentence trueSentence;
    Sentence falseSentence;
    Sentence andSentence;
    Sentence orSentence;
    Sentence impliedSentence;
    Sentence biConditionalSentence;

    public void setUp() {
        this.parser = new PEParser();
        this.trueSentence = (Sentence)this.parser.parse("true");
        this.falseSentence = (Sentence)this.parser.parse("false");
        this.andSentence = (Sentence)this.parser.parse("(P  AND  Q)");
        this.orSentence = (Sentence)this.parser.parse("(P  OR  Q)");
        this.impliedSentence = (Sentence)this.parser.parse("(P  =>  Q)");
        this.biConditionalSentence = (Sentence)this.parser.parse("(P  <=>  Q)");
        this.m = new Model();
    }

    public void testEmptyModel() {
        ModelTest.assertEquals(null, (Object)this.m.getStatus(new Symbol("P")));
        ModelTest.assertEquals((boolean)true, (boolean)this.m.isUnknown((Sentence)new Symbol("P")));
    }

    public void testExtendModel() {
        String string = "P";
        this.m = this.m.extend(new Symbol(string), true);
        ModelTest.assertEquals((Object)Boolean.TRUE, (Object)this.m.getStatus(new Symbol("P")));
    }

    public void testTrueFalseEvaluation() {
        ModelTest.assertEquals((boolean)true, (boolean)this.m.isTrue(this.trueSentence));
        ModelTest.assertEquals((boolean)false, (boolean)this.m.isFalse(this.trueSentence));
        ModelTest.assertEquals((boolean)false, (boolean)this.m.isTrue(this.falseSentence));
        ModelTest.assertEquals((boolean)true, (boolean)this.m.isFalse(this.falseSentence));
    }

    public void testSentenceStatusWhenPTrueAndQTrue() {
        String string = "P";
        String string2 = "Q";
        this.m = this.m.extend(new Symbol(string), true);
        this.m = this.m.extend(new Symbol(string2), true);
        ModelTest.assertEquals((boolean)true, (boolean)this.m.isTrue(this.andSentence));
        ModelTest.assertEquals((boolean)true, (boolean)this.m.isTrue(this.orSentence));
        ModelTest.assertEquals((boolean)true, (boolean)this.m.isTrue(this.impliedSentence));
        ModelTest.assertEquals((boolean)true, (boolean)this.m.isTrue(this.biConditionalSentence));
    }

    public void testSentenceStatusWhenPFalseAndQFalse() {
        String string = "P";
        String string2 = "Q";
        this.m = this.m.extend(new Symbol(string), false);
        this.m = this.m.extend(new Symbol(string2), false);
        ModelTest.assertEquals((boolean)true, (boolean)this.m.isFalse(this.andSentence));
        ModelTest.assertEquals((boolean)true, (boolean)this.m.isFalse(this.orSentence));
        ModelTest.assertEquals((boolean)true, (boolean)this.m.isTrue(this.impliedSentence));
        ModelTest.assertEquals((boolean)true, (boolean)this.m.isTrue(this.biConditionalSentence));
    }

    public void testSentenceStatusWhenPTrueAndQFalse() {
        String string = "P";
        String string2 = "Q";
        this.m = this.m.extend(new Symbol(string), true);
        this.m = this.m.extend(new Symbol(string2), false);
        ModelTest.assertEquals((boolean)true, (boolean)this.m.isFalse(this.andSentence));
        ModelTest.assertEquals((boolean)true, (boolean)this.m.isTrue(this.orSentence));
        ModelTest.assertEquals((boolean)true, (boolean)this.m.isFalse(this.impliedSentence));
        ModelTest.assertEquals((boolean)true, (boolean)this.m.isFalse(this.biConditionalSentence));
    }

    public void testSentenceStatusWhenPFalseAndQTrue() {
        String string = "P";
        String string2 = "Q";
        this.m = this.m.extend(new Symbol(string), false);
        this.m = this.m.extend(new Symbol(string2), true);
        ModelTest.assertEquals((boolean)true, (boolean)this.m.isFalse(this.andSentence));
        ModelTest.assertEquals((boolean)true, (boolean)this.m.isTrue(this.orSentence));
        ModelTest.assertEquals((boolean)true, (boolean)this.m.isTrue(this.impliedSentence));
        ModelTest.assertEquals((boolean)true, (boolean)this.m.isFalse(this.biConditionalSentence));
    }

    public void testComplexSentence() {
        String string = "P";
        String string2 = "Q";
        this.m = this.m.extend(new Symbol(string), true);
        this.m = this.m.extend(new Symbol(string2), false);
        Sentence sentence = (Sentence)this.parser.parse("((P OR Q) AND  (P => Q))");
        Sentence sentence2 = (Sentence)this.parser.parse("((P OR Q) AND  (Q))");
        ModelTest.assertFalse((boolean)this.m.isTrue(sentence));
        ModelTest.assertTrue((boolean)this.m.isFalse(sentence));
    }
}

