/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.prop.algorithms;

import aima.logic.propositional.algorithms.KnowledgeBase;
import aima.logic.propositional.algorithms.Model;
import aima.logic.propositional.algorithms.TTEntails;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import junit.framework.TestCase;

public class TTEntailsTest
extends TestCase {
    TTEntails tte;
    KnowledgeBase kb;

    public void setUp() {
        this.tte = new TTEntails();
        this.kb = new KnowledgeBase();
    }

    public void testSimpleSentence1() {
        this.kb.tell("(A AND B)");
        TTEntailsTest.assertEquals((boolean)true, (boolean)this.kb.askWithTTEntails("A"));
    }

    public void testSimpleSentence2() {
        this.kb.tell("(A OR B)");
        TTEntailsTest.assertEquals((boolean)false, (boolean)this.kb.askWithTTEntails("A"));
    }

    public void testSimpleSentence3() {
        this.kb.tell("((A => B) AND A)");
        TTEntailsTest.assertEquals((boolean)true, (boolean)this.kb.askWithTTEntails("B"));
    }

    public void testSimpleSentence4() {
        this.kb.tell("((A => B) AND B)");
        TTEntailsTest.assertEquals((boolean)false, (boolean)this.kb.askWithTTEntails("A"));
    }

    public void testSimpleSentence5() {
        this.kb.tell("A");
        TTEntailsTest.assertEquals((boolean)false, (boolean)this.kb.askWithTTEntails("NOT A"));
    }

    public void testSUnkownSymbol() {
        this.kb.tell("((A => B) AND B)");
        TTEntailsTest.assertEquals((boolean)false, (boolean)this.kb.askWithTTEntails("X"));
    }

    public void testSimpleSentence6() {
        this.kb.tell("NOT A");
        TTEntailsTest.assertEquals((boolean)false, (boolean)this.kb.askWithTTEntails("A"));
    }

    public void testNewAIMAExample() {
        this.kb.tell("(NOT P11)");
        this.kb.tell("(B11 <=> (P12 OR P21))");
        this.kb.tell("(B21 <=> ((P11 OR P22) OR P31))");
        this.kb.tell("(NOT B11)");
        this.kb.tell("(B21)");
        TTEntailsTest.assertEquals((boolean)true, (boolean)this.kb.askWithTTEntails("NOT P12"));
        TTEntailsTest.assertEquals((boolean)false, (boolean)this.kb.askWithTTEntails("P22"));
    }

    public void testTTEntailsSucceedsWithChadCarffsBugReport() {
        KnowledgeBase knowledgeBase = new KnowledgeBase();
        knowledgeBase.tell("(B12 <=> (P11 OR (P13 OR (P22 OR P02))))");
        knowledgeBase.tell("(B21 <=> (P20 OR (P22 OR (P31 OR P11))))");
        knowledgeBase.tell("(B01 <=> (P00 OR (P02 OR P11)))");
        knowledgeBase.tell("(B10 <=> (P11 OR (P20 OR P00)))");
        knowledgeBase.tell("(NOT B21)");
        knowledgeBase.tell("(NOT B12)");
        knowledgeBase.tell("(B10)");
        knowledgeBase.tell("(B01)");
        TTEntailsTest.assertTrue((boolean)knowledgeBase.askWithTTEntails("(P00)"));
        TTEntailsTest.assertFalse((boolean)knowledgeBase.askWithTTEntails("(NOT P00)"));
    }

    public void testModelEvaluation() {
        this.kb.tell("(NOT P11)");
        this.kb.tell("(B11 <=> (P12 OR P21))");
        this.kb.tell("(B21 <=> ((P11 OR P22) OR P31))");
        this.kb.tell("(NOT B11)");
        this.kb.tell("(B21)");
        Model model = new Model();
        model = model.extend(new Symbol("B11"), false);
        model = model.extend(new Symbol("B21"), true);
        model = model.extend(new Symbol("P11"), false);
        model = model.extend(new Symbol("P12"), false);
        model = model.extend(new Symbol("P21"), false);
        model = model.extend(new Symbol("P22"), false);
        model = model.extend(new Symbol("P31"), true);
        Sentence sentence = this.kb.asSentence();
        TTEntailsTest.assertEquals((boolean)true, (boolean)model.isTrue(sentence));
    }
}

