/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.prop.parser;

import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.AtomicSentence;
import aima.logic.propositional.parsing.ast.BinarySentence;
import aima.logic.propositional.parsing.ast.FalseSentence;
import aima.logic.propositional.parsing.ast.MultiSentence;
import aima.logic.propositional.parsing.ast.Symbol;
import aima.logic.propositional.parsing.ast.TrueSentence;
import aima.logic.propositional.parsing.ast.UnarySentence;
import junit.framework.TestCase;

public class PEParserTest
extends TestCase {
    private PEParser parser;

    public void setUp() {
        this.parser = new PEParser();
    }

    public void testAtomicSentenceTrueParse() {
        AtomicSentence atomicSentence = (AtomicSentence)this.parser.parse("true");
        PEParserTest.assertEquals(TrueSentence.class, atomicSentence.getClass());
        atomicSentence = (AtomicSentence)this.parser.parse("(true)");
        PEParserTest.assertEquals(TrueSentence.class, atomicSentence.getClass());
        atomicSentence = (AtomicSentence)this.parser.parse("((true))");
        PEParserTest.assertEquals(TrueSentence.class, atomicSentence.getClass());
    }

    public void testAtomicSentenceFalseParse() {
        AtomicSentence atomicSentence = (AtomicSentence)this.parser.parse("faLse");
        PEParserTest.assertEquals(FalseSentence.class, atomicSentence.getClass());
    }

    public void testAtomicSentenceSymbolParse() {
        AtomicSentence atomicSentence = (AtomicSentence)this.parser.parse("AIMA");
        PEParserTest.assertEquals(Symbol.class, atomicSentence.getClass());
    }

    public void testNotSentenceParse() {
        UnarySentence unarySentence = (UnarySentence)this.parser.parse("NOT AIMA");
        PEParserTest.assertEquals(UnarySentence.class, unarySentence.getClass());
    }

    public void testBinarySentenceParse() {
        BinarySentence binarySentence = (BinarySentence)this.parser.parse("(PETER  AND  NORVIG)");
        PEParserTest.assertEquals(BinarySentence.class, binarySentence.getClass());
    }

    public void testMultiSentenceAndParse() {
        MultiSentence multiSentence = (MultiSentence)this.parser.parse("(AND  NORVIG AIMA LISP)");
        PEParserTest.assertEquals(MultiSentence.class, multiSentence.getClass());
    }

    public void testMultiSentenceOrParse() {
        MultiSentence multiSentence = (MultiSentence)this.parser.parse("(OR  NORVIG AIMA LISP)");
        PEParserTest.assertEquals(MultiSentence.class, multiSentence.getClass());
    }

    public void testMultiSentenceBracketedParse() {
        MultiSentence multiSentence = (MultiSentence)this.parser.parse("((OR  NORVIG AIMA LISP))");
        PEParserTest.assertEquals(MultiSentence.class, multiSentence.getClass());
    }

    public void testComplexSentenceParse() {
        BinarySentence binarySentence = (BinarySentence)this.parser.parse("((OR  NORVIG AIMA LISP) AND TRUE)");
        PEParserTest.assertEquals(BinarySentence.class, binarySentence.getClass());
        binarySentence = (BinarySentence)this.parser.parse("((OR  NORVIG AIMA LISP) AND (((LISP => COOL))))");
        PEParserTest.assertEquals(BinarySentence.class, binarySentence.getClass());
        PEParserTest.assertEquals((String)" ( ( OR NORVIG AIMA LISP  )  AND  ( LISP => COOL ) )", (String)binarySentence.toString());
        String string = "((NOT (P AND Q ))  AND ((NOT (R AND S))))";
        binarySentence = (BinarySentence)this.parser.parse(string);
        PEParserTest.assertEquals((String)" (  ( NOT  ( P AND Q ) )  AND  ( NOT  ( R AND S ) )  )", (String)binarySentence.toString());
        string = "((P AND Q) OR (S AND T))";
        binarySentence = (BinarySentence)this.parser.parse(string);
        PEParserTest.assertEquals((String)" (  ( P AND Q ) OR  ( S AND T ) )", (String)binarySentence.toString());
        PEParserTest.assertEquals((String)"OR", (String)binarySentence.getOperator());
        string = "(NOT ((P AND Q) => (S AND T)))";
        UnarySentence unarySentence = (UnarySentence)this.parser.parse(string);
        string = "(NOT (P <=> (S AND T)))";
        unarySentence = (UnarySentence)this.parser.parse(string);
        PEParserTest.assertEquals((String)" ( NOT  ( P <=>  ( S AND T ) ) ) ", (String)unarySentence.toString());
        string = "(P <=> (S AND T))";
        binarySentence = (BinarySentence)this.parser.parse(string);
        string = "(P => Q)";
        binarySentence = (BinarySentence)this.parser.parse(string);
        string = "((P AND Q) => R)";
        binarySentence = (BinarySentence)this.parser.parse(string);
    }
}

