/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.prop.visitors;

import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.visitors.CNFTransformer;
import junit.framework.TestCase;

public class CNFTransformerTest
extends TestCase {
    private PEParser parser = new PEParser();
    private CNFTransformer transformer;

    public void setUp() {
        this.transformer = new CNFTransformer();
    }

    public void testSymbolTransform() {
        Sentence sentence = (Sentence)this.parser.parse("A");
        Sentence sentence2 = this.transformer.transform(sentence);
        CNFTransformerTest.assertEquals((String)"A", (String)sentence2.toString());
    }

    public void testBasicSentenceTransformation() {
        Sentence sentence = (Sentence)this.parser.parse("(A AND B)");
        Sentence sentence2 = this.transformer.transform(sentence);
        CNFTransformerTest.assertEquals((String)sentence.toString(), (String)sentence2.toString());
        Sentence sentence3 = (Sentence)this.parser.parse("(A OR B)");
        Sentence sentence4 = this.transformer.transform(sentence3);
        CNFTransformerTest.assertEquals((String)sentence3.toString(), (String)sentence4.toString());
        Sentence sentence5 = (Sentence)this.parser.parse("(NOT C)");
        Sentence sentence6 = this.transformer.transform(sentence5);
        CNFTransformerTest.assertEquals((String)sentence5.toString(), (String)sentence6.toString());
    }

    public void testImplicationTransformation() {
        Sentence sentence = (Sentence)this.parser.parse("(A => B)");
        Sentence sentence2 = (Sentence)this.parser.parse("((NOT A) OR B)");
        Sentence sentence3 = this.transformer.transform(sentence);
        CNFTransformerTest.assertEquals((String)sentence2.toString(), (String)sentence3.toString());
    }

    public void testBiConditionalTransformation() {
        Sentence sentence = (Sentence)this.parser.parse("(A <=> B)");
        Sentence sentence2 = (Sentence)this.parser.parse("(((NOT A) OR B)  AND ((NOT B) OR A)) ");
        Sentence sentence3 = this.transformer.transform(sentence);
        CNFTransformerTest.assertEquals((String)sentence2.toString(), (String)sentence3.toString());
    }

    public void testTwoSuccessiveNotsTransformation() {
        Sentence sentence = (Sentence)this.parser.parse("(NOT (NOT A))");
        Sentence sentence2 = (Sentence)this.parser.parse("A");
        Sentence sentence3 = this.transformer.transform(sentence);
        CNFTransformerTest.assertEquals((String)sentence2.toString(), (String)sentence3.toString());
    }

    public void testThreeSuccessiveNotsTransformation() {
        Sentence sentence = (Sentence)this.parser.parse("(NOT (NOT (NOT A)))");
        Sentence sentence2 = (Sentence)this.parser.parse("(NOT A)");
        Sentence sentence3 = this.transformer.transform(sentence);
        CNFTransformerTest.assertEquals((String)sentence2.toString(), (String)sentence3.toString());
    }

    public void testFourSuccessiveNotsTransformation() {
        Sentence sentence = (Sentence)this.parser.parse("(NOT (NOT (NOT (NOT A))))");
        Sentence sentence2 = (Sentence)this.parser.parse("A");
        Sentence sentence3 = this.transformer.transform(sentence);
        CNFTransformerTest.assertEquals((String)sentence2.toString(), (String)sentence3.toString());
    }

    public void testDeMorgan1() {
        Sentence sentence = (Sentence)this.parser.parse("(NOT (A AND B))");
        Sentence sentence2 = (Sentence)this.parser.parse("((NOT A) OR (NOT B))");
        Sentence sentence3 = this.transformer.transform(sentence);
        CNFTransformerTest.assertEquals((String)sentence2.toString(), (String)sentence3.toString());
    }

    public void testDeMorgan2() {
        Sentence sentence = (Sentence)this.parser.parse("(NOT (A OR B))");
        Sentence sentence2 = (Sentence)this.parser.parse("((NOT A) AND (NOT B))");
        Sentence sentence3 = this.transformer.transform(sentence);
        CNFTransformerTest.assertEquals((String)sentence2.toString(), (String)sentence3.toString());
    }

    public void testOrDistribution1() {
        Sentence sentence = (Sentence)this.parser.parse("((A AND B) OR C)");
        Sentence sentence2 = (Sentence)this.parser.parse("((C OR A) AND (C OR B))");
        Sentence sentence3 = this.transformer.transform(sentence);
        CNFTransformerTest.assertEquals((String)sentence2.toString(), (String)sentence3.toString());
    }

    public void testOrDistribution2() {
        Sentence sentence = (Sentence)this.parser.parse("(A OR (B AND C))");
        Sentence sentence2 = (Sentence)this.parser.parse("((A OR B) AND (A OR C))");
        Sentence sentence3 = this.transformer.transform(sentence);
        CNFTransformerTest.assertEquals((String)sentence2.toString(), (String)sentence3.toString());
    }

    public void testAimaExample() {
        Sentence sentence = (Sentence)this.parser.parse("( B11 <=> (P12 OR P21))");
        Sentence sentence2 = (Sentence)this.parser.parse(" (  (  ( NOT B11 )  OR  ( P12 OR P21 ) ) AND  (  ( B11 OR  ( NOT P12 )  ) AND  ( B11 OR  ( NOT P21 )  ) ) )");
        Sentence sentence3 = this.transformer.transform(sentence);
        CNFTransformerTest.assertEquals((String)sentence2.toString(), (String)sentence3.toString());
    }
}

