/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.prop.visitors;

import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import aima.logic.propositional.visitors.SymbolClassifier;
import java.util.Set;
import junit.framework.TestCase;

public class SymbolClassifierTest
extends TestCase {
    private SymbolClassifier classifier;
    private PEParser parser;

    public void setUp() {
        this.classifier = new SymbolClassifier();
        this.parser = new PEParser();
    }

    public void testSimpleNegativeSymbol() {
        Sentence sentence = (Sentence)this.parser.parse("(NOT B)");
        Set<Symbol> set = this.classifier.getNegativeSymbolsIn(sentence);
        Set<Symbol> set2 = this.classifier.getPositiveSymbolsIn(sentence);
        Set<Symbol> set3 = this.classifier.getPureNegativeSymbolsIn(sentence);
        Set<Symbol> set4 = this.classifier.getPurePositiveSymbolsIn(sentence);
        Set<Symbol> set5 = this.classifier.getPureSymbolsIn(sentence);
        Set<Symbol> set6 = this.classifier.getImpureSymbolsIn(sentence);
        Sentence sentence2 = (Sentence)this.parser.parse("B");
        SymbolClassifierTest.assertEquals((int)1, (int)set.size());
        SymbolClassifierTest.assertTrue((boolean)set.contains(sentence2));
        SymbolClassifierTest.assertEquals((int)0, (int)set2.size());
        SymbolClassifierTest.assertEquals((int)1, (int)set3.size());
        SymbolClassifierTest.assertTrue((boolean)set3.contains(sentence2));
        SymbolClassifierTest.assertEquals((int)0, (int)set4.size());
        SymbolClassifierTest.assertEquals((int)1, (int)set5.size());
        SymbolClassifierTest.assertTrue((boolean)set5.contains(sentence2));
        SymbolClassifierTest.assertEquals((int)0, (int)set6.size());
    }

    public void testSimplePositiveSymbol() {
        Sentence sentence = (Sentence)this.parser.parse("B");
        Set<Symbol> set = this.classifier.getNegativeSymbolsIn(sentence);
        Set<Symbol> set2 = this.classifier.getPositiveSymbolsIn(sentence);
        Set<Symbol> set3 = this.classifier.getPureNegativeSymbolsIn(sentence);
        Set<Symbol> set4 = this.classifier.getPurePositiveSymbolsIn(sentence);
        Set<Symbol> set5 = this.classifier.getPureSymbolsIn(sentence);
        Set<Symbol> set6 = this.classifier.getImpureSymbolsIn(sentence);
        SymbolClassifierTest.assertEquals((int)0, (int)set.size());
        SymbolClassifierTest.assertEquals((int)1, (int)set2.size());
        Sentence sentence2 = (Sentence)this.parser.parse("B");
        SymbolClassifierTest.assertTrue((boolean)set2.contains(sentence2));
        SymbolClassifierTest.assertEquals((int)1, (int)set4.size());
        SymbolClassifierTest.assertTrue((boolean)set4.contains(sentence2));
        SymbolClassifierTest.assertEquals((int)0, (int)set3.size());
        SymbolClassifierTest.assertEquals((int)1, (int)set5.size());
        SymbolClassifierTest.assertTrue((boolean)set5.contains(sentence2));
        SymbolClassifierTest.assertEquals((int)0, (int)set6.size());
    }

    public void testSingleSymbolPositiveAndNegative() {
        Sentence sentence = (Sentence)this.parser.parse("(B AND (NOT B))");
        Set<Symbol> set = this.classifier.getNegativeSymbolsIn(sentence);
        Set<Symbol> set2 = this.classifier.getPositiveSymbolsIn(sentence);
        Set<Symbol> set3 = this.classifier.getPureNegativeSymbolsIn(sentence);
        Set<Symbol> set4 = this.classifier.getPurePositiveSymbolsIn(sentence);
        Set<Symbol> set5 = this.classifier.getPureSymbolsIn(sentence);
        Set<Symbol> set6 = this.classifier.getImpureSymbolsIn(sentence);
        Sentence sentence2 = (Sentence)this.parser.parse("B");
        SymbolClassifierTest.assertEquals((int)1, (int)set.size());
        SymbolClassifierTest.assertTrue((boolean)set.contains(sentence2));
        SymbolClassifierTest.assertEquals((int)1, (int)set2.size());
        SymbolClassifierTest.assertTrue((boolean)set2.contains(sentence2));
        SymbolClassifierTest.assertEquals((int)0, (int)set3.size());
        SymbolClassifierTest.assertEquals((int)0, (int)set4.size());
        SymbolClassifierTest.assertEquals((int)0, (int)set5.size());
        SymbolClassifierTest.assertEquals((int)1, (int)set6.size());
    }

    public void testAIMAExample() {
        Sentence sentence = (Sentence)this.parser.parse("(((A OR (NOT B)) AND ((NOT B) OR (NOT C))) AND (C OR A))");
        Set<Symbol> set = this.classifier.getNegativeSymbolsIn(sentence);
        Set<Symbol> set2 = this.classifier.getPositiveSymbolsIn(sentence);
        Set<Symbol> set3 = this.classifier.getPureNegativeSymbolsIn(sentence);
        Set<Symbol> set4 = this.classifier.getPurePositiveSymbolsIn(sentence);
        Set<Symbol> set5 = this.classifier.getPureSymbolsIn(sentence);
        Set<Symbol> set6 = this.classifier.getImpureSymbolsIn(sentence);
        Sentence sentence2 = (Sentence)this.parser.parse("A");
        Sentence sentence3 = (Sentence)this.parser.parse("B");
        Sentence sentence4 = (Sentence)this.parser.parse("C");
        SymbolClassifierTest.assertEquals((int)2, (int)set.size());
        SymbolClassifierTest.assertTrue((boolean)set.contains(sentence3));
        SymbolClassifierTest.assertTrue((boolean)set.contains(sentence4));
        SymbolClassifierTest.assertEquals((int)2, (int)set2.size());
        SymbolClassifierTest.assertTrue((boolean)set2.contains(sentence2));
        SymbolClassifierTest.assertTrue((boolean)set2.contains(sentence4));
        SymbolClassifierTest.assertEquals((int)1, (int)set3.size());
        SymbolClassifierTest.assertTrue((boolean)set3.contains(sentence3));
        SymbolClassifierTest.assertEquals((int)1, (int)set4.size());
        SymbolClassifierTest.assertTrue((boolean)set4.contains(sentence2));
        SymbolClassifierTest.assertEquals((int)2, (int)set5.size());
        SymbolClassifierTest.assertTrue((boolean)set5.contains(sentence2));
        SymbolClassifierTest.assertTrue((boolean)set5.contains(sentence3));
        SymbolClassifierTest.assertEquals((int)1, (int)set6.size());
        SymbolClassifierTest.assertTrue((boolean)set6.contains(sentence4));
    }
}

