/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.prop.visitors;

import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import aima.logic.propositional.visitors.SymbolCollector;
import java.util.Set;
import junit.framework.TestCase;

public class SymbolCollectorTest
extends TestCase {
    private PEParser parser;
    private SymbolCollector collector;

    public void setUp() {
        this.parser = new PEParser();
        this.collector = new SymbolCollector();
    }

    public void testCollectSymbolsFromComplexSentence() {
        Sentence sentence = (Sentence)this.parser.parse(" (  (  ( NOT B11 )  OR  ( P12 OR P21 ) ) AND  (  ( B11 OR  ( NOT P12 )  ) AND  ( B11 OR  ( NOT P21 )  ) ) )");
        Set<Symbol> set = this.collector.getSymbolsIn(sentence);
        SymbolCollectorTest.assertEquals((int)3, (int)set.size());
        Sentence sentence2 = (Sentence)this.parser.parse("B11");
        Sentence sentence3 = (Sentence)this.parser.parse("P21");
        Sentence sentence4 = (Sentence)this.parser.parse("P12");
        SymbolCollectorTest.assertTrue((boolean)set.contains(sentence2));
        SymbolCollectorTest.assertTrue((boolean)set.contains(sentence3));
        SymbolCollectorTest.assertTrue((boolean)set.contains(sentence4));
    }
}

