/*
 * Decompiled with CFR 0.152.
 */
package aima.test.probdecisiontest;

import aima.probability.Randomizer;
import aima.probability.decision.MDP;
import aima.probability.decision.MDPFactory;
import aima.probability.decision.MDPPolicy;
import aima.probability.decision.MDPUtilityFunction;
import aima.probability.decision.cellworld.CellWorldPosition;
import junit.framework.TestCase;

public class PolicyIterationTest
extends TestCase {
    private MDP<CellWorldPosition, String> fourByThreeMDP;
    private Randomizer alwaysLessThanEightyPercent;

    public void setUp() {
        this.fourByThreeMDP = MDPFactory.createFourByThreeMDP();
    }

    public void testPolicyEvaluation() {
        MDPPolicy<CellWorldPosition, String> mDPPolicy = this.fourByThreeMDP.randomPolicy();
        MDPUtilityFunction<CellWorldPosition> mDPUtilityFunction = this.fourByThreeMDP.initialUtilityFunction();
        MDPUtilityFunction<CellWorldPosition> mDPUtilityFunction2 = this.fourByThreeMDP.policyEvaluation(mDPPolicy, mDPUtilityFunction, 1.0, 3);
        PolicyIterationTest.assertFalse((boolean)mDPUtilityFunction.equals(mDPUtilityFunction2));
    }

    public void testPolicyIteration() {
        MDPPolicy<CellWorldPosition, String> mDPPolicy = this.fourByThreeMDP.policyIteration(1.0);
        PolicyIterationTest.assertEquals((String)"up", (String)mDPPolicy.getAction(new CellWorldPosition(1, 1)));
        PolicyIterationTest.assertEquals((String)"up", (String)mDPPolicy.getAction(new CellWorldPosition(2, 1)));
        PolicyIterationTest.assertEquals((String)"right", (String)mDPPolicy.getAction(new CellWorldPosition(3, 1)));
        PolicyIterationTest.assertEquals((String)"left", (String)mDPPolicy.getAction(new CellWorldPosition(1, 2)));
        PolicyIterationTest.assertEquals((String)"right", (String)mDPPolicy.getAction(new CellWorldPosition(3, 2)));
        PolicyIterationTest.assertEquals((String)"left", (String)mDPPolicy.getAction(new CellWorldPosition(1, 3)));
        PolicyIterationTest.assertEquals((String)"up", (String)mDPPolicy.getAction(new CellWorldPosition(2, 3)));
        PolicyIterationTest.assertEquals((String)"right", (String)mDPPolicy.getAction(new CellWorldPosition(3, 3)));
        PolicyIterationTest.assertEquals((String)"left", (String)mDPPolicy.getAction(new CellWorldPosition(1, 4)));
    }
}

