/*
 * Decompiled with CFR 0.152.
 */
package aima.test.probreasoningtest;

import aima.probability.reasoning.HMMAgent;
import aima.probability.reasoning.HMMFactory;
import junit.framework.TestCase;

public class HMMAgentTest
extends TestCase {
    private static final double TOLERANCE = 0.001;
    private HMMAgent robot;
    private HMMAgent rainman;

    public void setUp() {
        this.robot = new HMMAgent(HMMFactory.createRobotHMM());
        this.rainman = new HMMAgent(HMMFactory.createRainmanHMM());
    }

    public void testRobotInitialization() {
        HMMAgentTest.assertEquals((Object)0.5, (Object)this.robot.belief().getProbabilityOf("open"));
        HMMAgentTest.assertEquals((Object)0.5, (Object)this.robot.belief().getProbabilityOf("closed"));
    }

    public void testRobotHMMPredictionAndMeasurementUpdateStepsModifyBeliefCorrectly() {
        HMMAgentTest.assertEquals((Object)0.5, (Object)this.robot.belief().getProbabilityOf("open"));
        HMMAgentTest.assertEquals((Object)0.5, (Object)this.robot.belief().getProbabilityOf("closed"));
        this.robot.act("do_nothing");
        HMMAgentTest.assertEquals((Object)0.5, (Object)this.robot.belief().getProbabilityOf("open"));
        HMMAgentTest.assertEquals((Object)0.5, (Object)this.robot.belief().getProbabilityOf("closed"));
        this.robot.perceive("see_open");
        HMMAgentTest.assertEquals((double)0.75, (double)this.robot.belief().getProbabilityOf("open"), (double)0.001);
        HMMAgentTest.assertEquals((double)0.25, (double)this.robot.belief().getProbabilityOf("closed"), (double)0.001);
        this.robot.act("push");
        HMMAgentTest.assertEquals((Object)0.95, (Object)this.robot.belief().getProbabilityOf("open"));
        HMMAgentTest.assertEquals((Object)0.05, (Object)this.robot.belief().getProbabilityOf("closed"));
        this.robot.perceive("see_open");
        HMMAgentTest.assertEquals((double)0.983, (double)this.robot.belief().getProbabilityOf("open"), (double)0.001);
        HMMAgentTest.assertEquals((double)0.017, (double)this.robot.belief().getProbabilityOf("closed"), (double)0.001);
    }

    public void testRainmanInitialization() {
        HMMAgentTest.assertEquals((Object)0.5, (Object)this.rainman.belief().getProbabilityOf("rain"));
        HMMAgentTest.assertEquals((Object)0.5, (Object)this.rainman.belief().getProbabilityOf("no_rain"));
    }

    public void testRainmanHMMPredictionAndMeasurementUpdateStepsModifyBeliefCorrectly() {
        HMMAgentTest.assertEquals((Object)0.5, (Object)this.rainman.belief().getProbabilityOf("rain"));
        HMMAgentTest.assertEquals((Object)0.5, (Object)this.rainman.belief().getProbabilityOf("no_rain"));
        this.rainman.waitWithoutActing();
        HMMAgentTest.assertEquals((Object)0.5, (Object)this.rainman.belief().getProbabilityOf("rain"));
        HMMAgentTest.assertEquals((Object)0.5, (Object)this.rainman.belief().getProbabilityOf("no_rain"));
        this.rainman.perceive("carries_umbrella");
        HMMAgentTest.assertEquals((double)0.818, (double)this.rainman.belief().getProbabilityOf("rain"), (double)0.001);
        HMMAgentTest.assertEquals((double)0.182, (double)this.rainman.belief().getProbabilityOf("no_rain"), (double)0.001);
        this.rainman.waitWithoutActing();
        HMMAgentTest.assertEquals((double)0.627, (double)this.rainman.belief().getProbabilityOf("rain"), (double)0.001);
        HMMAgentTest.assertEquals((double)0.373, (double)this.rainman.belief().getProbabilityOf("no_rain"), (double)0.001);
        this.rainman.perceive("carries_umbrella");
        HMMAgentTest.assertEquals((double)0.883, (double)this.rainman.belief().getProbabilityOf("rain"), (double)0.001);
        HMMAgentTest.assertEquals((double)0.117, (double)this.rainman.belief().getProbabilityOf("no_rain"), (double)0.001);
    }
}

