/*
 * Decompiled with CFR 0.152.
 */
package aima.test.probreasoningtest;

import aima.probability.RandomVariable;
import aima.probability.Randomizer;
import aima.probability.reasoning.HMMFactory;
import aima.probability.reasoning.HiddenMarkovModel;
import aima.probability.reasoning.Particle;
import aima.probability.reasoning.ParticleSet;
import aima.probability.reasoning.TransitionModel;
import aima.test.probabilitytest.MockRandomizer;
import junit.framework.TestCase;

public class ParticleFilterTest
extends TestCase {
    private HiddenMarkovModel rainman;
    private HiddenMarkovModel robot;
    ParticleSet particleSet;
    Randomizer randomizer;

    public void setUp() {
        this.rainman = HMMFactory.createRainmanHMM();
        this.robot = HMMFactory.createRobotHMM();
        this.randomizer = new MockRandomizer(new double[]{0.1, 0.9});
        this.particleSet = new ParticleSet(this.rainman);
        this.particleSet.add(new Particle("rain"));
        this.particleSet.add(new Particle("rain"));
        this.particleSet.add(new Particle("rain"));
        this.particleSet.add(new Particle("no_rain"));
    }

    public void testFilteringWithParticleSetsWorksForRainmanHmm() {
        MockRandomizer mockRandomizer = new MockRandomizer(new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9});
        ParticleSet particleSet = this.rainman.prior().toParticleSet(this.rainman, mockRandomizer, 100);
        ParticleFilterTest.assertEquals((int)56, (int)particleSet.numberOfParticlesWithState("rain"));
        ParticleFilterTest.assertEquals((int)44, (int)particleSet.numberOfParticlesWithState("no_rain"));
        ParticleSet particleSet2 = particleSet.filter("carries_umbrella", mockRandomizer);
        ParticleFilterTest.assertEquals((int)84, (int)particleSet2.numberOfParticlesWithState("rain"));
        ParticleFilterTest.assertEquals((int)16, (int)particleSet2.numberOfParticlesWithState("no_rain"));
        ParticleSet particleSet3 = particleSet.filter("does_not_carry_umbrella", mockRandomizer);
        ParticleFilterTest.assertEquals((int)12, (int)particleSet3.numberOfParticlesWithState("rain"));
        ParticleFilterTest.assertEquals((int)88, (int)particleSet3.numberOfParticlesWithState("no_rain"));
    }

    public void testFilteringWithParticleSetsForRobotHmm() {
        MockRandomizer mockRandomizer = new MockRandomizer(new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9});
        ParticleSet particleSet = this.robot.prior().toParticleSet(this.robot, mockRandomizer, 100);
        ParticleFilterTest.assertEquals((int)56, (int)particleSet.numberOfParticlesWithState("open"));
        ParticleFilterTest.assertEquals((int)44, (int)particleSet.numberOfParticlesWithState("closed"));
        ParticleSet particleSet2 = particleSet.filter("see_open", mockRandomizer);
        ParticleFilterTest.assertEquals((int)66, (int)particleSet2.numberOfParticlesWithState("open"));
        ParticleFilterTest.assertEquals((int)34, (int)particleSet2.numberOfParticlesWithState("closed"));
        ParticleSet particleSet3 = particleSet.filter("push", "see_open", mockRandomizer);
        ParticleFilterTest.assertEquals((int)100, (int)particleSet3.numberOfParticlesWithState("open"));
        ParticleFilterTest.assertEquals((int)0, (int)particleSet3.numberOfParticlesWithState("closed"));
    }

    public void testRandomVariableConversionToParticleSet() {
        RandomVariable randomVariable = this.rainman.prior();
        ParticleSet particleSet = randomVariable.toParticleSet(this.rainman, this.randomizer, 10);
        ParticleFilterTest.assertEquals((int)5, (int)particleSet.numberOfParticlesWithState("rain"));
        ParticleFilterTest.assertEquals((int)5, (int)particleSet.numberOfParticlesWithState("no_rain"));
    }

    public void testParticleSetConversionToRandomVariable() {
        RandomVariable randomVariable = this.particleSet.toRandomVariable();
        ParticleFilterTest.assertEquals((Object)0.75, (Object)randomVariable.getProbabilityOf("rain"));
        ParticleFilterTest.assertEquals((Object)0.25, (Object)randomVariable.getProbabilityOf("no_rain"));
    }

    public void testRoundTripConversion() {
        RandomVariable randomVariable = this.particleSet.toRandomVariable();
        MockRandomizer mockRandomizer = new MockRandomizer(new double[]{0.1, 0.2, 0.3, 0.4, 0.9});
        ParticleSet particleSet = randomVariable.toParticleSet(this.rainman, mockRandomizer, 10);
        ParticleFilterTest.assertEquals((int)8, (int)particleSet.numberOfParticlesWithState("rain"));
        ParticleFilterTest.assertEquals((int)2, (int)particleSet.numberOfParticlesWithState("no_rain"));
    }

    public void testTransitionModelGeneratesNewStateWhenGivenOldStateAndProbability() {
        TransitionModel transitionModel = this.rainman.transitionModel();
        String string = "rain";
        String string2 = transitionModel.getStateForProbability(string, this.randomizer.nextDouble());
        String string3 = transitionModel.getStateForProbability(string, this.randomizer.nextDouble());
        ParticleFilterTest.assertEquals((String)string2, (String)"rain");
        ParticleFilterTest.assertEquals((String)string3, (String)"no_rain");
    }

    public void testParticleSetForPredictedStateGeneratedFromOldStateParticleSet() {
        MockRandomizer mockRandomizer = new MockRandomizer(new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9});
        ParticleSet particleSet = this.rainman.prior().toParticleSet(this.rainman, mockRandomizer, 10);
        ParticleFilterTest.assertEquals((int)6, (int)particleSet.numberOfParticlesWithState("rain"));
        ParticleFilterTest.assertEquals((int)4, (int)particleSet.numberOfParticlesWithState("no_rain"));
        ParticleSet particleSet2 = particleSet.generateParticleSetForPredictedState(mockRandomizer);
        ParticleFilterTest.assertEquals((int)7, (int)particleSet2.numberOfParticlesWithState("rain"));
        ParticleFilterTest.assertEquals((int)3, (int)particleSet2.numberOfParticlesWithState("no_rain"));
    }

    public void testParticleSetForPerceptionUpdatedStateGeneratedFromPredictedStateParticleSetGivenPerception() {
        MockRandomizer mockRandomizer = new MockRandomizer(new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9});
        ParticleSet particleSet = this.rainman.prior().toParticleSet(this.rainman, mockRandomizer, 10);
        ParticleSet particleSet2 = particleSet.generateParticleSetForPredictedState(mockRandomizer);
        ParticleSet particleSet3 = particleSet2.perceptionUpdate("carries_umbrella", mockRandomizer);
        ParticleFilterTest.assertEquals((int)9, (int)particleSet3.numberOfParticlesWithState("rain"));
        ParticleFilterTest.assertEquals((int)1, (int)particleSet3.numberOfParticlesWithState("no_rain"));
        ParticleSet particleSet4 = particleSet2.perceptionUpdate("does_not_carry_umbrella", mockRandomizer);
        ParticleFilterTest.assertEquals((int)2, (int)particleSet4.numberOfParticlesWithState("rain"));
        ParticleFilterTest.assertEquals((int)8, (int)particleSet4.numberOfParticlesWithState("no_rain"));
    }
}

