/*
 * Decompiled with CFR 0.152.
 */
package aima.test.regression.logic.fol;

import aima.logic.fol.inference.FOLTFMResolution;
import aima.logic.fol.inference.InferenceResult;
import aima.logic.fol.inference.trace.FOLTFMResolutionTracer;
import aima.logic.fol.kb.data.Clause;
import aima.test.logictest.foltest.CommonFOLInferenceProcedureTests;
import java.util.Set;

public class FOLTFMResolutionRegression
extends CommonFOLInferenceProcedureTests {
    public void testFullFOLKBLovesAnimalQueryKillsJackTunaFalse() {
        FOLTFMResolution fOLTFMResolution = new FOLTFMResolution(1000000L);
        fOLTFMResolution.setTracer(new RegressionFOLTFMResolutionTracer());
        this.testFullFOLKBLovesAnimalQueryKillsJackTunaFalse(fOLTFMResolution, true);
    }

    private class RegressionFOLTFMResolutionTracer
    implements FOLTFMResolutionTracer {
        private int outerCnt = 1;
        private int noPairsConsidered = 0;
        private int noPairsResolved = 0;
        private int maxClauseSizeSeen = 0;

        private RegressionFOLTFMResolutionTracer() {
        }

        @Override
        public void stepStartWhile(Set<Clause> set, int n, int n2) {
            this.outerCnt = 1;
            System.out.println("");
            System.out.println("Total # clauses=" + n + ", total # new candidate clauses=" + n2);
        }

        @Override
        public void stepOuterFor(Clause clause) {
            System.out.print(" " + this.outerCnt);
            if (this.outerCnt % 50 == 0) {
                System.out.println("");
            }
            ++this.outerCnt;
        }

        @Override
        public void stepInnerFor(Clause clause, Clause clause2) {
            ++this.noPairsConsidered;
        }

        @Override
        public void stepResolved(Clause clause, Clause clause2, Set<Clause> set) {
            ++this.noPairsResolved;
            Clause clause3 = null;
            for (Clause clause4 : set) {
                if (clause4.getNumberLiterals() <= this.maxClauseSizeSeen) continue;
                clause3 = clause4;
                this.maxClauseSizeSeen = clause4.getNumberLiterals();
            }
            if (null != clause3) {
                System.out.println("");
                System.out.println("E.g. largest clause so far=" + this.maxClauseSizeSeen + ", " + clause3);
                System.out.println("i=" + clause);
                System.out.println("j=" + clause2);
            }
        }

        @Override
        public void stepFinished(Set<Clause> set, InferenceResult inferenceResult) {
            System.out.println("Total # Pairs of Clauses Considered:" + this.noPairsConsidered);
            System.out.println("Total # Pairs of Clauses Resolved  :" + this.noPairsResolved);
            this.noPairsConsidered = 0;
            this.noPairsResolved = 0;
            this.maxClauseSizeSeen = 0;
        }
    }
}

