/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.map;

import aima.basic.BasicEnvironmentView;
import aima.search.framework.GraphSearch;
import aima.search.framework.Search;
import aima.search.map.ExtendableMap;
import aima.search.map.MapAgent;
import aima.search.map.MapEnvironment;
import aima.search.uninformed.UniformCostSearch;
import junit.framework.TestCase;

public class MapAgentTest
extends TestCase {
    ExtendableMap aMap;
    StringBuffer envChanges;

    public void setUp() {
        this.aMap = new ExtendableMap();
        this.aMap.addBidirectionalLink("A", "B", 5.0);
        this.aMap.addBidirectionalLink("A", "C", 6.0);
        this.aMap.addBidirectionalLink("B", "C", 4.0);
        this.aMap.addBidirectionalLink("C", "D", 7.0);
        this.aMap.addUnidirectionalLink("B", "E", 14.0);
        this.envChanges = new StringBuffer();
    }

    public void testAlreadyAtGoal() {
        MapEnvironment mapEnvironment = new MapEnvironment(this.aMap);
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)new UniformCostSearch(new GraphSearch()), new String[]{"A"});
        mapEnvironment.addAgent(mapAgent, "A");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                MapAgentTest.this.envChanges.append(string).append(":");
            }
        });
        mapEnvironment.stepUntilDone();
        MapAgentTest.assertEquals((String)"CurrentLocation=In(A), Goal=In(A):NoOP:METRIC[pathCost]=0.0:METRIC[maxQueueSize]=1:METRIC[queueSize]=0:METRIC[nodesExpanded]=0:NoOP:", (String)this.envChanges.toString());
    }

    public void testNormalSearch() {
        MapEnvironment mapEnvironment = new MapEnvironment(this.aMap);
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)new UniformCostSearch(new GraphSearch()), new String[]{"D"});
        mapEnvironment.addAgent(mapAgent, "A");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                MapAgentTest.this.envChanges.append(string).append(":");
            }
        });
        mapEnvironment.stepUntilDone();
        MapAgentTest.assertEquals((String)"CurrentLocation=In(A), Goal=In(D):C:D:METRIC[pathCost]=13.0:METRIC[maxQueueSize]=6:METRIC[queueSize]=1:METRIC[nodesExpanded]=3:NoOP:", (String)this.envChanges.toString());
    }

    public void testNoPath() {
        MapEnvironment mapEnvironment = new MapEnvironment(this.aMap);
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)new UniformCostSearch(new GraphSearch()), new String[]{"A"});
        mapEnvironment.addAgent(mapAgent, "E");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                MapAgentTest.this.envChanges.append(string).append(":");
            }
        });
        mapEnvironment.stepUntilDone();
        MapAgentTest.assertEquals((String)"CurrentLocation=In(E), Goal=In(A):NoOP:METRIC[pathCost]=0:METRIC[maxQueueSize]=1:METRIC[queueSize]=0:METRIC[nodesExpanded]=1:NoOP:", (String)this.envChanges.toString());
    }
}

