/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.map;

import aima.basic.Percept;
import aima.search.framework.GraphSearch;
import aima.search.framework.Search;
import aima.search.map.ExtendableMap;
import aima.search.map.MapAgent;
import aima.search.map.MapEnvironment;
import aima.search.uninformed.UniformCostSearch;
import junit.framework.TestCase;

public class MapEnvironmentTest
extends TestCase {
    MapEnvironment me;
    MapAgent ma;

    public void setUp() {
        ExtendableMap extendableMap = new ExtendableMap();
        extendableMap.addBidirectionalLink("A", "B", 5.0);
        extendableMap.addBidirectionalLink("A", "C", 6.0);
        extendableMap.addBidirectionalLink("B", "C", 4.0);
        extendableMap.addBidirectionalLink("C", "D", 7.0);
        extendableMap.addUnidirectionalLink("B", "E", 14.0);
        this.me = new MapEnvironment(extendableMap);
        this.ma = new MapAgent(this.me, (Search)new UniformCostSearch(new GraphSearch()), new String[]{"A"});
    }

    public void testAddAgent() {
        this.me.addAgent(this.ma, "E");
        MapEnvironmentTest.assertEquals((Object)this.ma.getAttribute("location"), (Object)"E");
    }

    public void testExecuteAction() {
        this.me.addAgent(this.ma, "D");
        this.me.executeAction(this.ma, "C");
        MapEnvironmentTest.assertEquals((Object)this.ma.getAttribute("location"), (Object)"C");
    }

    public void testPerceptSeenBy() {
        this.me.addAgent(this.ma, "D");
        Percept percept = this.me.getPerceptSeenBy(this.ma);
        MapEnvironmentTest.assertEquals((Object)percept.getAttribute("In"), (Object)"D");
    }
}

