/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.map;

import aima.search.map.ExtendableMap;
import aima.search.map.MapStepCostFunction;
import junit.framework.TestCase;

public class MapStepCostFunctionTest
extends TestCase {
    MapStepCostFunction mscf;

    public void setUp() {
        ExtendableMap extendableMap = new ExtendableMap();
        extendableMap.addBidirectionalLink("A", "B", 5.0);
        extendableMap.addBidirectionalLink("A", "C", 6.0);
        extendableMap.addBidirectionalLink("B", "C", 4.0);
        extendableMap.addBidirectionalLink("C", "D", 7.0);
        extendableMap.addUnidirectionalLink("B", "E", 14.0);
        this.mscf = new MapStepCostFunction(extendableMap);
    }

    public void testCosts() {
        MapStepCostFunctionTest.assertEquals((Object)new Double(5.0), (Object)this.mscf.calculateStepCost("A", "B", "Go"));
        MapStepCostFunctionTest.assertEquals((Object)new Double(6.0), (Object)this.mscf.calculateStepCost("A", "C", "Go"));
        MapStepCostFunctionTest.assertEquals((Object)new Double(4.0), (Object)this.mscf.calculateStepCost("B", "C", "Go"));
        MapStepCostFunctionTest.assertEquals((Object)new Double(7.0), (Object)this.mscf.calculateStepCost("C", "D", "Go"));
        MapStepCostFunctionTest.assertEquals((Object)new Double(14.0), (Object)this.mscf.calculateStepCost("B", "E", "Go"));
        MapStepCostFunctionTest.assertEquals((Object)new Double(5.0), (Object)this.mscf.calculateStepCost("B", "A", "Go"));
        MapStepCostFunctionTest.assertEquals((Object)new Double(6.0), (Object)this.mscf.calculateStepCost("C", "A", "Go"));
        MapStepCostFunctionTest.assertEquals((Object)new Double(4.0), (Object)this.mscf.calculateStepCost("C", "B", "Go"));
        MapStepCostFunctionTest.assertEquals((Object)new Double(7.0), (Object)this.mscf.calculateStepCost("D", "C", "Go"));
        MapStepCostFunctionTest.assertEquals((Object)new Double(1.0), (Object)this.mscf.calculateStepCost("X", "Z", "Go"));
        MapStepCostFunctionTest.assertEquals((Object)new Double(1.0), (Object)this.mscf.calculateStepCost("A", "Z", "Go"));
        MapStepCostFunctionTest.assertEquals((Object)new Double(1.0), (Object)this.mscf.calculateStepCost("A", "D", "Go"));
        MapStepCostFunctionTest.assertEquals((Object)new Double(1.0), (Object)this.mscf.calculateStepCost("A", "E", "Go"));
    }
}

