/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.nqueens;

import aima.basic.XYLocation;
import aima.search.nqueens.NQueensBoard;
import junit.framework.TestCase;

public class NQueensBoardTest
extends TestCase {
    NQueensBoard board;

    public void setUp() {
        this.board = new NQueensBoard(8);
    }

    public void testBasics() {
        NQueensBoardTest.assertEquals((int)0, (int)this.board.getNumberOfQueensOnBoard());
        this.board.addQueenAt(new XYLocation(0, 0));
        NQueensBoardTest.assertEquals((int)1, (int)this.board.getNumberOfQueensOnBoard());
        this.board.addQueenAt(new XYLocation(0, 0));
        NQueensBoardTest.assertEquals((int)1, (int)this.board.getNumberOfQueensOnBoard());
        this.board.addQueenAt(new XYLocation(1, 1));
        NQueensBoardTest.assertEquals((int)2, (int)this.board.getNumberOfQueensOnBoard());
        NQueensBoardTest.assertTrue((boolean)this.board.queenExistsAt(new XYLocation(1, 1)));
        NQueensBoardTest.assertTrue((boolean)this.board.queenExistsAt(new XYLocation(0, 0)));
        this.board.moveQueen(new XYLocation(1, 1), new XYLocation(3, 3));
        NQueensBoardTest.assertTrue((boolean)this.board.queenExistsAt(new XYLocation(3, 3)));
        NQueensBoardTest.assertTrue((!this.board.queenExistsAt(new XYLocation(1, 1)) ? 1 : 0) != 0);
        NQueensBoardTest.assertEquals((int)2, (int)this.board.getNumberOfQueensOnBoard());
    }

    public void testCornerQueenAttack1() {
        this.board.addQueenAt(new XYLocation(0, 0));
        NQueensBoardTest.assertEquals((boolean)false, (boolean)this.board.isSquareUnderAttack(new XYLocation(0, 0)));
        NQueensBoardTest.assertEquals((boolean)true, (boolean)this.board.isSquareUnderAttack(new XYLocation(1, 0)));
        NQueensBoardTest.assertEquals((boolean)true, (boolean)this.board.isSquareUnderAttack(new XYLocation(7, 0)));
        NQueensBoardTest.assertEquals((boolean)true, (boolean)this.board.isSquareUnderAttack(new XYLocation(0, 7)));
        NQueensBoardTest.assertEquals((boolean)true, (boolean)this.board.isSquareUnderAttack(new XYLocation(1, 1)));
        NQueensBoardTest.assertEquals((boolean)true, (boolean)this.board.isSquareUnderAttack(new XYLocation(2, 2)));
        NQueensBoardTest.assertEquals((boolean)false, (boolean)this.board.isSquareUnderAttack(new XYLocation(2, 1)));
        NQueensBoardTest.assertEquals((boolean)false, (boolean)this.board.isSquareUnderAttack(new XYLocation(1, 2)));
    }

    public void testCornerQueenAttack2() {
        this.board.addQueenAt(new XYLocation(7, 7));
        NQueensBoardTest.assertEquals((boolean)true, (boolean)this.board.isSquareUnderAttack(new XYLocation(0, 0)));
        NQueensBoardTest.assertEquals((boolean)true, (boolean)this.board.isSquareUnderAttack(new XYLocation(7, 0)));
        NQueensBoardTest.assertEquals((boolean)true, (boolean)this.board.isSquareUnderAttack(new XYLocation(0, 7)));
        NQueensBoardTest.assertEquals((boolean)true, (boolean)this.board.isSquareUnderAttack(new XYLocation(7, 0)));
        NQueensBoardTest.assertEquals((boolean)true, (boolean)this.board.isSquareUnderAttack(new XYLocation(6, 6)));
        NQueensBoardTest.assertEquals((boolean)true, (boolean)this.board.isSquareUnderAttack(new XYLocation(5, 5)));
        NQueensBoardTest.assertEquals((boolean)false, (boolean)this.board.isSquareUnderAttack(new XYLocation(6, 5)));
        NQueensBoardTest.assertEquals((boolean)false, (boolean)this.board.isSquareUnderAttack(new XYLocation(5, 6)));
    }

    public void testEdgeQueenAttack() {
        this.board.addQueenAt(new XYLocation(0, 3));
        NQueensBoardTest.assertEquals((boolean)true, (boolean)this.board.isSquareUnderAttack(new XYLocation(0, 0)));
        NQueensBoardTest.assertEquals((boolean)true, (boolean)this.board.isSquareUnderAttack(new XYLocation(0, 7)));
        NQueensBoardTest.assertEquals((boolean)true, (boolean)this.board.isSquareUnderAttack(new XYLocation(7, 3)));
        NQueensBoardTest.assertEquals((boolean)true, (boolean)this.board.isSquareUnderAttack(new XYLocation(3, 0)));
        NQueensBoardTest.assertEquals((boolean)true, (boolean)this.board.isSquareUnderAttack(new XYLocation(4, 7)));
    }

    public void testAttack2() {
        this.board.addQueenAt(new XYLocation(7, 0));
        NQueensBoardTest.assertEquals((boolean)true, (boolean)this.board.isSquareUnderAttack(new XYLocation(6, 1)));
    }

    public void testAttack3() {
        this.board.addQueenAt(new XYLocation(0, 0));
        NQueensBoardTest.assertEquals((boolean)true, (boolean)this.board.isSquareUnderAttack(new XYLocation(0, 1)));
    }

    public void testAttack4() {
        this.board.addQueenAt(new XYLocation(0, 2));
        NQueensBoardTest.assertTrue((boolean)this.board.isSquareUnderAttack(new XYLocation(1, 1)));
    }

    public void testMidBoardDiagonalAttack() {
        this.board.addQueenAt(new XYLocation(3, 3));
        NQueensBoardTest.assertTrue((boolean)this.board.isSquareUnderAttack(new XYLocation(4, 2)));
        NQueensBoardTest.assertTrue((boolean)this.board.isSquareUnderAttack(new XYLocation(4, 4)));
        NQueensBoardTest.assertTrue((boolean)this.board.isSquareUnderAttack(new XYLocation(2, 2)));
        NQueensBoardTest.assertTrue((boolean)this.board.isSquareUnderAttack(new XYLocation(2, 4)));
    }

    public void testCornerDiagonalAttack() {
        this.board.addQueenAt(new XYLocation(0, 0));
        NQueensBoardTest.assertTrue((boolean)this.board.isSquareUnderAttack(new XYLocation(1, 1)));
        this.board.clear();
        this.board.addQueenAt(new XYLocation(7, 7));
        NQueensBoardTest.assertTrue((boolean)this.board.isSquareUnderAttack(new XYLocation(6, 6)));
    }

    public void testAttack6() {
        this.board.addQueenAt(new XYLocation(1, 6));
        NQueensBoardTest.assertTrue((boolean)this.board.isSquareUnderAttack(new XYLocation(0, 7)));
    }

    public void testRemoveQueen() {
        this.board.addQueenAt(new XYLocation(0, 0));
        NQueensBoardTest.assertEquals((int)1, (int)this.board.getNumberOfQueensOnBoard());
        this.board.removeQueenFrom(new XYLocation(0, 0));
        NQueensBoardTest.assertEquals((int)0, (int)this.board.getNumberOfQueensOnBoard());
    }

    public void testMoveQueen() {
        XYLocation xYLocation = new XYLocation(0, 0);
        XYLocation xYLocation2 = new XYLocation(1, 1);
        this.board.addQueenAt(xYLocation);
        NQueensBoardTest.assertEquals((int)1, (int)this.board.getNumberOfQueensOnBoard());
        NQueensBoardTest.assertTrue((boolean)this.board.queenExistsAt(xYLocation));
        NQueensBoardTest.assertFalse((boolean)this.board.queenExistsAt(xYLocation2));
        this.board.moveQueen(xYLocation, xYLocation2);
        NQueensBoardTest.assertEquals((int)1, (int)this.board.getNumberOfQueensOnBoard());
        NQueensBoardTest.assertFalse((boolean)this.board.queenExistsAt(xYLocation));
        NQueensBoardTest.assertTrue((boolean)this.board.queenExistsAt(xYLocation2));
    }

    public void testMoveNonExistentQueen() {
        XYLocation xYLocation = new XYLocation(0, 0);
        XYLocation xYLocation2 = new XYLocation(1, 1);
        this.board.moveQueen(xYLocation, xYLocation2);
        NQueensBoardTest.assertEquals((int)0, (int)this.board.getNumberOfQueensOnBoard());
    }

    public void testRemoveNonExistentQueen() {
        this.board.removeQueenFrom(new XYLocation(0, 0));
        NQueensBoardTest.assertEquals((int)0, (int)this.board.getNumberOfQueensOnBoard());
    }

    public void testEquality() {
        this.board.addQueenAt(new XYLocation(0, 0));
        NQueensBoard nQueensBoard = new NQueensBoard(8);
        nQueensBoard.addQueenAt(new XYLocation(0, 0));
        NQueensBoardTest.assertEquals((Object)this.board, (Object)nQueensBoard);
        NQueensBoard nQueensBoard2 = new NQueensBoard(8);
        nQueensBoard2.addQueenAt(new XYLocation(0, 1));
        NQueensBoardTest.assertFalse((boolean)this.board.equals(nQueensBoard2));
    }

    public void testPrint() {
        NQueensBoard nQueensBoard = new NQueensBoard(2);
        nQueensBoard.addQueenAt(new XYLocation(0, 0));
        String string = " Q  - \n -  - \n";
        NQueensBoardTest.assertEquals((String)string, (String)nQueensBoard.getBoardPic());
    }

    public void testDontPlaceTwoQueensOnOneSquare() {
        this.board.addQueenAt(new XYLocation(0, 0));
        this.board.addQueenAt(new XYLocation(0, 0));
        NQueensBoardTest.assertEquals((int)1, (int)this.board.getNumberOfQueensOnBoard());
    }

    public void testSimpleHorizontalAttack() {
        XYLocation xYLocation = new XYLocation(0, 0);
        this.board.addQueenAt(xYLocation);
        NQueensBoardTest.assertEquals((int)0, (int)this.board.getNumberOfAttacksOn(xYLocation));
        NQueensBoardTest.assertEquals((int)1, (int)this.board.getNumberOfAttacksOn(new XYLocation(1, 0)));
        NQueensBoardTest.assertEquals((int)1, (int)this.board.getNumberOfAttacksOn(xYLocation.right()));
        NQueensBoardTest.assertEquals((int)1, (int)this.board.getNumberOfAttacksOn(new XYLocation(7, 0)));
    }

    public void testSimpleVerticalAttack() {
        XYLocation xYLocation = new XYLocation(0, 0);
        this.board.addQueenAt(xYLocation);
        NQueensBoardTest.assertEquals((int)0, (int)this.board.getNumberOfAttacksOn(xYLocation));
        NQueensBoardTest.assertEquals((int)1, (int)this.board.getNumberOfAttacksOn(xYLocation.down()));
        NQueensBoardTest.assertEquals((int)1, (int)this.board.getNumberOfAttacksOn(new XYLocation(0, 7)));
    }

    public void testSimpleDiagonalAttack() {
        XYLocation xYLocation = new XYLocation(3, 3);
        this.board.addQueenAt(xYLocation);
        NQueensBoardTest.assertEquals((int)0, (int)this.board.getNumberOfAttacksOn(xYLocation));
        NQueensBoardTest.assertEquals((int)1, (int)this.board.getNumberOfAttacksOn(xYLocation.down().right()));
        NQueensBoardTest.assertEquals((int)1, (int)this.board.getNumberOfAttacksOn(xYLocation.down().left()));
        NQueensBoardTest.assertEquals((int)1, (int)this.board.getNumberOfAttacksOn(xYLocation.up().left()));
        NQueensBoardTest.assertEquals((int)1, (int)this.board.getNumberOfAttacksOn(xYLocation.up().right()));
        NQueensBoardTest.assertEquals((int)1, (int)this.board.getNumberOfAttacksOn(new XYLocation(7, 7)));
        NQueensBoardTest.assertEquals((int)1, (int)this.board.getNumberOfAttacksOn(new XYLocation(0, 0)));
        NQueensBoardTest.assertEquals((int)1, (int)this.board.getNumberOfAttacksOn(new XYLocation(6, 0)));
        NQueensBoardTest.assertEquals((int)1, (int)this.board.getNumberOfAttacksOn(new XYLocation(0, 6)));
    }

    public void testMultipleQueens() {
        XYLocation xYLocation = new XYLocation(3, 3);
        this.board.addQueenAt(xYLocation);
        NQueensBoardTest.assertEquals((int)1, (int)this.board.getNumberOfAttacksOn(xYLocation.right()));
        this.board.addQueenAt(xYLocation.right().right());
        NQueensBoardTest.assertEquals((int)1, (int)this.board.getNumberOfAttacksOn(xYLocation));
        NQueensBoardTest.assertEquals((int)2, (int)this.board.getNumberOfAttacksOn(xYLocation.right()));
        this.board.addQueenAt(xYLocation.right().down());
        NQueensBoardTest.assertEquals((int)2, (int)this.board.getNumberOfAttacksOn(xYLocation));
        NQueensBoardTest.assertEquals((int)3, (int)this.board.getNumberOfAttacksOn(xYLocation.right()));
        NQueensBoardTest.assertEquals((int)2, (int)this.board.getNumberOfAttacksOn(xYLocation.right().right()));
    }

    public void testBoardDisplay() {
        this.board.addQueenAt(new XYLocation(0, 5));
        this.board.addQueenAt(new XYLocation(1, 6));
        this.board.addQueenAt(new XYLocation(2, 1));
        this.board.addQueenAt(new XYLocation(3, 3));
        this.board.addQueenAt(new XYLocation(4, 6));
        this.board.addQueenAt(new XYLocation(5, 4));
        this.board.addQueenAt(new XYLocation(6, 7));
        this.board.addQueenAt(new XYLocation(7, 7));
        NQueensBoardTest.assertEquals((String)" -  -  -  -  -  -  -  - \n -  -  Q  -  -  -  -  - \n -  -  -  -  -  -  -  - \n -  -  -  Q  -  -  -  - \n -  -  -  -  -  Q  -  - \n Q  -  -  -  -  -  -  - \n -  Q  -  -  Q  -  -  - \n -  -  -  -  -  -  Q  Q \n", (String)this.board.getBoardPic());
        NQueensBoardTest.assertEquals((String)"--------\n--Q-----\n--------\n---Q----\n-----Q--\nQ-------\n-Q--Q---\n------QQ\n", (String)this.board.toString());
    }
}

