/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.searches;

import aima.search.framework.Problem;
import aima.search.framework.SearchAgent;
import aima.search.framework.TreeSearch;
import aima.search.nqueens.NQueensBoard;
import aima.search.nqueens.NQueensGoalTest;
import aima.search.nqueens.NQueensSuccessorFunction;
import aima.search.uninformed.BreadthFirstSearch;
import java.util.List;
import junit.framework.TestCase;

public class BreadthFirstSearchTest
extends TestCase {
    public void testBreadthFirstSuccesfulSearch() throws Exception {
        Problem problem = new Problem(new NQueensBoard(8), new NQueensSuccessorFunction(), new NQueensGoalTest());
        BreadthFirstSearch breadthFirstSearch = new BreadthFirstSearch(new TreeSearch());
        SearchAgent searchAgent = new SearchAgent(problem, breadthFirstSearch);
        List list = searchAgent.getActions();
        this.assertCorrectPlacement(list);
        BreadthFirstSearchTest.assertEquals((String)"1965", (String)searchAgent.getInstrumentation().getProperty("nodesExpanded"));
        problem = new Problem(new NQueensBoard(3), new NQueensSuccessorFunction(), new NQueensGoalTest());
        searchAgent = new SearchAgent(problem, breadthFirstSearch);
        list = searchAgent.getActions();
        BreadthFirstSearchTest.assertEquals((int)0, (int)list.size());
        BreadthFirstSearchTest.assertEquals((String)"6", (String)searchAgent.getInstrumentation().getProperty("nodesExpanded"));
    }

    public void testBreadthFirstUnSuccesfulSearch() throws Exception {
        Problem problem = new Problem(new NQueensBoard(3), new NQueensSuccessorFunction(), new NQueensGoalTest());
        BreadthFirstSearch breadthFirstSearch = new BreadthFirstSearch(new TreeSearch());
        SearchAgent searchAgent = new SearchAgent(problem, breadthFirstSearch);
        List list = searchAgent.getActions();
        BreadthFirstSearchTest.assertEquals((int)0, (int)list.size());
        BreadthFirstSearchTest.assertEquals((String)"6", (String)searchAgent.getInstrumentation().getProperty("nodesExpanded"));
    }

    private void assertCorrectPlacement(List list) {
        BreadthFirstSearchTest.assertEquals((int)8, (int)list.size());
        BreadthFirstSearchTest.assertEquals((Object)"placeQueenAt 0  0", list.get(0));
        BreadthFirstSearchTest.assertEquals((Object)"placeQueenAt 1  4", list.get(1));
        BreadthFirstSearchTest.assertEquals((Object)"placeQueenAt 2  7", list.get(2));
        BreadthFirstSearchTest.assertEquals((Object)"placeQueenAt 3  5", list.get(3));
        BreadthFirstSearchTest.assertEquals((Object)"placeQueenAt 4  2", list.get(4));
        BreadthFirstSearchTest.assertEquals((Object)"placeQueenAt 5  6", list.get(5));
        BreadthFirstSearchTest.assertEquals((Object)"placeQueenAt 6  1", list.get(6));
        BreadthFirstSearchTest.assertEquals((Object)"placeQueenAt 7  3", list.get(7));
    }
}

