/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.searches;

import aima.basic.BasicEnvironmentView;
import aima.search.framework.HeuristicFunction;
import aima.search.framework.Search;
import aima.search.informed.AStarEvaluationFunction;
import aima.search.informed.RecursiveBestFirstSearch;
import aima.search.map.Map;
import aima.search.map.MapAgent;
import aima.search.map.MapEnvironment;
import aima.search.map.Point2D;
import aima.search.map.SimplifiedRoadMapOfPartOfRomania;
import junit.framework.TestCase;

public class RecursiveBestFirstSearchTest
extends TestCase {
    StringBuffer envChanges;
    Map aMap;
    RecursiveBestFirstSearch recursiveBestFirstSearch;
    HeuristicFunction heuristicFunction;

    public void setUp() {
        this.envChanges = new StringBuffer();
        this.aMap = new SimplifiedRoadMapOfPartOfRomania();
        this.recursiveBestFirstSearch = new RecursiveBestFirstSearch(new AStarEvaluationFunction());
        this.heuristicFunction = new HeuristicFunction(){

            @Override
            public double getHeuristicValue(Object object) {
                Point2D point2D = RecursiveBestFirstSearchTest.this.aMap.getPosition((String)object);
                Point2D point2D2 = RecursiveBestFirstSearchTest.this.aMap.getPosition("Bucharest");
                return point2D.distance(point2D2);
            }
        };
    }

    public void testStartingAtGoal() {
        MapEnvironment mapEnvironment = new MapEnvironment(this.aMap);
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)this.recursiveBestFirstSearch, new String[]{"Bucharest"});
        mapAgent.setHeuristicFunction(this.heuristicFunction);
        mapEnvironment.addAgent(mapAgent, "Bucharest");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                RecursiveBestFirstSearchTest.this.envChanges.append(string).append(":");
            }
        });
        mapEnvironment.stepUntilDone();
        RecursiveBestFirstSearchTest.assertEquals((String)"CurrentLocation=In(Bucharest), Goal=In(Bucharest):NoOP:METRIC[pathCost]=0.0:METRIC[maxRecursiveDepth]=0:METRIC[nodesExpanded]=0:NoOP:", (String)this.envChanges.toString());
    }

    public void testExampleFromBookFigure4_6Page103() {
        MapEnvironment mapEnvironment = new MapEnvironment(this.aMap);
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)this.recursiveBestFirstSearch, new String[]{"Bucharest"});
        mapAgent.setHeuristicFunction(this.heuristicFunction);
        mapEnvironment.addAgent(mapAgent, "Arad");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                RecursiveBestFirstSearchTest.this.envChanges.append(string).append(":");
            }
        });
        mapEnvironment.stepUntilDone();
        RecursiveBestFirstSearchTest.assertEquals((String)"CurrentLocation=In(Arad), Goal=In(Bucharest):Sibiu:RimnicuVilcea:Pitesti:Bucharest:METRIC[pathCost]=418.0:METRIC[maxRecursiveDepth]=4:METRIC[nodesExpanded]=6:NoOP:", (String)this.envChanges.toString());
    }
}

