/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.searches;

import aima.search.framework.GraphSearch;
import aima.search.framework.Problem;
import aima.search.framework.SearchAgent;
import aima.search.nqueens.NQueensBoard;
import aima.search.nqueens.NQueensGoalTest;
import aima.search.nqueens.NQueensSuccessorFunction;
import aima.search.uninformed.UniformCostSearch;
import java.util.List;
import junit.framework.TestCase;

public class UniformCostSearchTest
extends TestCase {
    public void testUniformCostSuccesfulSearch() throws Exception {
        Problem problem = new Problem(new NQueensBoard(8), new NQueensSuccessorFunction(), new NQueensGoalTest());
        UniformCostSearch uniformCostSearch = new UniformCostSearch(new GraphSearch());
        SearchAgent searchAgent = new SearchAgent(problem, uniformCostSearch);
        List list = searchAgent.getActions();
        UniformCostSearchTest.assertEquals((int)8, (int)list.size());
        UniformCostSearchTest.assertEquals((String)"1965", (String)searchAgent.getInstrumentation().getProperty("nodesExpanded"));
        UniformCostSearchTest.assertEquals((String)"8.0", (String)searchAgent.getInstrumentation().getProperty("pathCost"));
    }

    public void testUniformCostUnSuccesfulSearch() throws Exception {
        Problem problem = new Problem(new NQueensBoard(3), new NQueensSuccessorFunction(), new NQueensGoalTest());
        UniformCostSearch uniformCostSearch = new UniformCostSearch(new GraphSearch());
        SearchAgent searchAgent = new SearchAgent(problem, uniformCostSearch);
        List list = searchAgent.getActions();
        UniformCostSearchTest.assertEquals((int)0, (int)list.size());
        UniformCostSearchTest.assertEquals((String)"6", (String)searchAgent.getInstrumentation().getProperty("nodesExpanded"));
        UniformCostSearchTest.assertEquals((String)"0", (String)searchAgent.getInstrumentation().getProperty("pathCost"));
    }
}

