/*
 * Decompiled with CFR 0.152.
 */
package aima.test.tvenvironmenttest;

import aima.basic.BasicEnvironmentView;
import aima.basic.vaccum.TableDrivenVaccumAgent;
import aima.basic.vaccum.TrivialVaccumEnvironment;
import junit.framework.TestCase;

public class TableDrivenVaccumAgentTest
extends TestCase {
    private TableDrivenVaccumAgent agent;
    private StringBuffer envChanges;

    public void setUp() {
        this.agent = new TableDrivenVaccumAgent();
        this.envChanges = new StringBuffer();
    }

    public void testCleanClean() {
        TrivialVaccumEnvironment trivialVaccumEnvironment = new TrivialVaccumEnvironment("Clean", "Clean");
        trivialVaccumEnvironment.addAgent(this.agent, "A");
        trivialVaccumEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                TableDrivenVaccumAgentTest.this.envChanges.append(string);
            }
        });
        trivialVaccumEnvironment.stepUntilDone();
        TableDrivenVaccumAgentTest.assertEquals((String)"RightLeftRightNoOP", (String)this.envChanges.toString());
    }

    public void testCleanDirty() {
        TrivialVaccumEnvironment trivialVaccumEnvironment = new TrivialVaccumEnvironment("Clean", "Dirty");
        trivialVaccumEnvironment.addAgent(this.agent, "A");
        trivialVaccumEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                TableDrivenVaccumAgentTest.this.envChanges.append(string);
            }
        });
        trivialVaccumEnvironment.stepUntilDone();
        TableDrivenVaccumAgentTest.assertEquals((String)"RightSuckLeftNoOP", (String)this.envChanges.toString());
    }

    public void testDirtyClean() {
        TrivialVaccumEnvironment trivialVaccumEnvironment = new TrivialVaccumEnvironment("Dirty", "Clean");
        trivialVaccumEnvironment.addAgent(this.agent, "A");
        trivialVaccumEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                TableDrivenVaccumAgentTest.this.envChanges.append(string);
            }
        });
        trivialVaccumEnvironment.stepUntilDone();
        TableDrivenVaccumAgentTest.assertEquals((String)"SuckRightLeftNoOP", (String)this.envChanges.toString());
    }

    public void testDirtyDirty() {
        TrivialVaccumEnvironment trivialVaccumEnvironment = new TrivialVaccumEnvironment("Dirty", "Dirty");
        trivialVaccumEnvironment.addAgent(this.agent, "A");
        trivialVaccumEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                TableDrivenVaccumAgentTest.this.envChanges.append(string);
            }
        });
        trivialVaccumEnvironment.stepUntilDone();
        TableDrivenVaccumAgentTest.assertEquals((String)"SuckRightSuckNoOP", (String)this.envChanges.toString());
    }
}

