/*
 * Decompiled with CFR 0.152.
 */
package aima.test.utiltest;

import aima.util.Util;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class MeanStDevTests
extends TestCase {
    private List<Double> values;

    public void setUp() {
        this.values = new ArrayList<Double>();
        this.values.add(1.0);
        this.values.add(2.0);
        this.values.add(3.0);
        this.values.add(4.0);
        this.values.add(5.0);
    }

    public void testMeanCalculation() {
        MeanStDevTests.assertEquals((Object)3.0, (Object)Util.calculateMean(this.values));
    }

    public void testStDevCalculation() {
        MeanStDevTests.assertEquals((double)1.5811, (double)Util.calculateStDev(this.values, 3.0), (double)0.001);
    }

    public void testNormalization() {
        List<Double> list = Util.normalizeFromMeanAndStdev(this.values, 3.0, 1.5811);
        MeanStDevTests.assertEquals((double)-1.264, (double)list.get(0), (double)0.001);
        MeanStDevTests.assertEquals((double)-0.632, (double)list.get(1), (double)0.001);
        MeanStDevTests.assertEquals((double)0.0, (double)list.get(2), (double)0.001);
        MeanStDevTests.assertEquals((double)0.632, (double)list.get(3), (double)0.001);
        MeanStDevTests.assertEquals((double)1.264, (double)list.get(4), (double)0.001);
    }

    public void testRandomNumberGenrationWhenStartAndEndNumbersAreSame() {
        int n = Util.randomNumberBetween(0, 0);
        int n2 = Util.randomNumberBetween(23, 23);
        MeanStDevTests.assertEquals((int)0, (int)n);
        MeanStDevTests.assertEquals((int)23, (int)n2);
    }
}

