/*
 * Decompiled with CFR 0.152.
 */
package aima.test.utiltest;

import aima.util.MixedRadixNumber;
import junit.framework.TestCase;

public class MixedRadixNumberTest
extends TestCase {
    public void testInvalidRadixs() {
        try {
            new MixedRadixNumber(100L, new int[]{1, 0, -1});
            MixedRadixNumberTest.fail((String)"Should have thrown an Illegal Argument Exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInvalidMaxValue() {
        try {
            new MixedRadixNumber(100L, new int[]{3, 3, 3});
            MixedRadixNumberTest.fail((String)"Should have thrown an Illegal Argument Exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAllowedMaxValue() {
        MixedRadixNumberTest.assertEquals((long)15L, (long)new MixedRadixNumber(0L, new int[]{2, 2, 2, 2}).getMaxAllowedValue());
        MixedRadixNumberTest.assertEquals((long)80L, (long)new MixedRadixNumber(0L, new int[]{3, 3, 3, 3}).getMaxAllowedValue());
        MixedRadixNumberTest.assertEquals((long)5L, (long)new MixedRadixNumber(0L, new int[]{3, 2}).getMaxAllowedValue());
        MixedRadixNumberTest.assertEquals((long)35L, (long)new MixedRadixNumber(0L, new int[]{3, 3, 2, 2}).getMaxAllowedValue());
        MixedRadixNumberTest.assertEquals((long)359L, (long)new MixedRadixNumber(0L, new int[]{3, 4, 5, 6}).getMaxAllowedValue());
        MixedRadixNumberTest.assertEquals((long)359L, (long)new MixedRadixNumber(0L, new int[]{6, 5, 4, 3}).getMaxAllowedValue());
    }

    public void testIncrement() {
        MixedRadixNumber mixedRadixNumber = new MixedRadixNumber(0L, new int[]{3, 2});
        int n = 0;
        while (mixedRadixNumber.increment()) {
            ++n;
        }
        MixedRadixNumberTest.assertEquals((long)n, (long)mixedRadixNumber.getMaxAllowedValue());
    }

    public void testDecrement() {
        MixedRadixNumber mixedRadixNumber = new MixedRadixNumber(5L, new int[]{3, 2});
        int n = 0;
        while (mixedRadixNumber.decrement()) {
            ++n;
        }
        MixedRadixNumberTest.assertEquals((long)n, (long)mixedRadixNumber.getMaxAllowedValue());
    }

    public void testCurrentNumberalValue() {
        MixedRadixNumber mixedRadixNumber = new MixedRadixNumber(0L, new int[]{3, 3, 2, 2});
        MixedRadixNumberTest.assertEquals((int)0, (int)mixedRadixNumber.getCurrentNumeralValue(0));
        MixedRadixNumberTest.assertEquals((int)0, (int)mixedRadixNumber.getCurrentNumeralValue(1));
        MixedRadixNumberTest.assertEquals((int)0, (int)mixedRadixNumber.getCurrentNumeralValue(2));
        MixedRadixNumberTest.assertEquals((int)0, (int)mixedRadixNumber.getCurrentNumeralValue(3));
        mixedRadixNumber = new MixedRadixNumber(35L, new int[]{3, 3, 2, 2});
        MixedRadixNumberTest.assertEquals((int)2, (int)mixedRadixNumber.getCurrentNumeralValue(0));
        MixedRadixNumberTest.assertEquals((int)2, (int)mixedRadixNumber.getCurrentNumeralValue(1));
        MixedRadixNumberTest.assertEquals((int)1, (int)mixedRadixNumber.getCurrentNumeralValue(2));
        MixedRadixNumberTest.assertEquals((int)1, (int)mixedRadixNumber.getCurrentNumeralValue(3));
        mixedRadixNumber = new MixedRadixNumber(25L, new int[]{3, 3, 2, 2});
        MixedRadixNumberTest.assertEquals((int)1, (int)mixedRadixNumber.getCurrentNumeralValue(0));
        MixedRadixNumberTest.assertEquals((int)2, (int)mixedRadixNumber.getCurrentNumeralValue(1));
        MixedRadixNumberTest.assertEquals((int)0, (int)mixedRadixNumber.getCurrentNumeralValue(2));
        MixedRadixNumberTest.assertEquals((int)1, (int)mixedRadixNumber.getCurrentNumeralValue(3));
        mixedRadixNumber = new MixedRadixNumber(17L, new int[]{3, 3, 2, 2});
        MixedRadixNumberTest.assertEquals((int)2, (int)mixedRadixNumber.getCurrentNumeralValue(0));
        MixedRadixNumberTest.assertEquals((int)2, (int)mixedRadixNumber.getCurrentNumeralValue(1));
        MixedRadixNumberTest.assertEquals((int)1, (int)mixedRadixNumber.getCurrentNumeralValue(2));
        MixedRadixNumberTest.assertEquals((int)0, (int)mixedRadixNumber.getCurrentNumeralValue(3));
        mixedRadixNumber = new MixedRadixNumber(8L, new int[]{3, 3, 2, 2});
        MixedRadixNumberTest.assertEquals((int)2, (int)mixedRadixNumber.getCurrentNumeralValue(0));
        MixedRadixNumberTest.assertEquals((int)2, (int)mixedRadixNumber.getCurrentNumeralValue(1));
        MixedRadixNumberTest.assertEquals((int)0, (int)mixedRadixNumber.getCurrentNumeralValue(2));
        MixedRadixNumberTest.assertEquals((int)0, (int)mixedRadixNumber.getCurrentNumeralValue(3));
        mixedRadixNumber = new MixedRadixNumber(359L, new int[]{3, 4, 5, 6});
        MixedRadixNumberTest.assertEquals((int)2, (int)mixedRadixNumber.getCurrentNumeralValue(0));
        MixedRadixNumberTest.assertEquals((int)3, (int)mixedRadixNumber.getCurrentNumeralValue(1));
        MixedRadixNumberTest.assertEquals((int)4, (int)mixedRadixNumber.getCurrentNumeralValue(2));
        MixedRadixNumberTest.assertEquals((int)5, (int)mixedRadixNumber.getCurrentNumeralValue(3));
        mixedRadixNumber = new MixedRadixNumber(359L, new int[]{6, 5, 4, 3});
        MixedRadixNumberTest.assertEquals((int)5, (int)mixedRadixNumber.getCurrentNumeralValue(0));
        MixedRadixNumberTest.assertEquals((int)4, (int)mixedRadixNumber.getCurrentNumeralValue(1));
        MixedRadixNumberTest.assertEquals((int)3, (int)mixedRadixNumber.getCurrentNumeralValue(2));
        MixedRadixNumberTest.assertEquals((int)2, (int)mixedRadixNumber.getCurrentNumeralValue(3));
    }
}

