/*
 * Decompiled with CFR 0.152.
 */
package aima.test.utiltest;

import aima.util.SetOps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;

public class SetTest
extends TestCase {
    Set<Integer> s1;
    Set<Integer> s2;

    public void setUp() {
        this.s1 = new HashSet<Integer>();
        this.s1.add(new Integer(1));
        this.s1.add(new Integer(2));
        this.s1.add(new Integer(3));
        this.s1.add(new Integer(4));
        this.s2 = new HashSet<Integer>();
        this.s2.add(new Integer(4));
        this.s2.add(new Integer(5));
        this.s2.add(new Integer(6));
    }

    public void testUnion() {
        Set<Integer> set = new SetOps<Integer>().union(this.s1, this.s2);
        SetTest.assertEquals((int)6, (int)set.size());
        SetTest.assertEquals((int)4, (int)this.s1.size());
        SetTest.assertEquals((int)3, (int)this.s2.size());
        this.s1.remove(new Integer(1));
        SetTest.assertEquals((int)6, (int)set.size());
        SetTest.assertEquals((int)3, (int)this.s1.size());
        SetTest.assertEquals((int)3, (int)this.s2.size());
    }

    public void testIntersection() {
        Set<Integer> set = new SetOps<Integer>().intersection(this.s1, this.s2);
        SetTest.assertEquals((int)1, (int)set.size());
        SetTest.assertEquals((int)4, (int)this.s1.size());
        SetTest.assertEquals((int)3, (int)this.s2.size());
        this.s1.remove(new Integer(1));
        SetTest.assertEquals((int)1, (int)set.size());
        SetTest.assertEquals((int)3, (int)this.s1.size());
        SetTest.assertEquals((int)3, (int)this.s2.size());
    }

    public void testDifference() {
        Set<Integer> set = new SetOps<Integer>().difference(this.s1, this.s2);
        SetTest.assertEquals((int)3, (int)set.size());
        SetTest.assertTrue((boolean)set.contains(new Integer(1)));
        SetTest.assertTrue((boolean)set.contains(new Integer(2)));
        SetTest.assertTrue((boolean)set.contains(new Integer(3)));
    }

    public void testDifference2() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        hashSet.add(new Integer(1));
        hashSet2.add(new Integer(1));
        Set set = new SetOps<Integer>().difference(hashSet, hashSet2);
        SetTest.assertTrue((boolean)set.isEmpty());
    }

    public void testListRemove() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(new Integer(1));
        SetTest.assertEquals((int)1, (int)arrayList.size());
        arrayList.remove(0);
        SetTest.assertEquals((int)0, (int)arrayList.size());
    }
}

