/*
 * Decompiled with CFR 0.152.
 */
package aima.util;

import java.util.List;

public class MixedRadixNumber
extends Number {
    private static final long serialVersionUID = 1L;
    private long value = 0L;
    private long maxValue = 0L;
    private int[] radixs = null;
    private int[] currentNumeralValue = null;
    private boolean recalculate = true;

    public MixedRadixNumber(long l, int[] nArray) {
        this.value = l;
        this.radixs = new int[nArray.length];
        System.arraycopy(nArray, 0, this.radixs, 0, nArray.length);
        this.calculateMaxValue();
    }

    public MixedRadixNumber(long l, List<Integer> list) {
        this.value = l;
        this.radixs = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.radixs[i] = list.get(i);
        }
        this.calculateMaxValue();
    }

    public long getMaxAllowedValue() {
        return this.maxValue;
    }

    public boolean increment() {
        if (this.value < this.maxValue) {
            ++this.value;
            this.recalculate = true;
            return true;
        }
        return false;
    }

    public boolean decrement() {
        if (this.value > 0L) {
            --this.value;
            this.recalculate = true;
            return true;
        }
        return false;
    }

    public int getCurrentNumeralValue(int n) {
        if (n >= 0 && n < this.radixs.length) {
            if (this.recalculate) {
                long l = this.value;
                for (int i = 0; i < this.radixs.length; ++i) {
                    if (0L != l) {
                        this.currentNumeralValue[i] = (int)l % this.radixs[i];
                        l /= (long)this.radixs[i];
                        continue;
                    }
                    this.currentNumeralValue[i] = 0;
                }
                this.recalculate = false;
            }
            return this.currentNumeralValue[n];
        }
        throw new IllegalArgumentException("Argument atPosition must be >=0 and < " + this.radixs.length);
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.longValue();
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.radixs.length; ++i) {
            stringBuilder.append("[");
            stringBuilder.append(this.getCurrentNumeralValue(i));
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    private void calculateMaxValue() {
        int n;
        if (0 == this.radixs.length) {
            throw new IllegalArgumentException("At least 1 radix must be defined.");
        }
        for (n = 0; n < this.radixs.length; ++n) {
            if (this.radixs[n] >= 2) continue;
            throw new IllegalArgumentException("Invalid radix, must be >= 2");
        }
        this.maxValue = this.radixs[0];
        for (n = 1; n < this.radixs.length; ++n) {
            this.maxValue *= (long)this.radixs[n];
        }
        --this.maxValue;
        if (this.value > this.maxValue) {
            throw new IllegalArgumentException("The value [" + this.value + "] cannot be represented with the radixs provided, max value is " + this.maxValue);
        }
        this.currentNumeralValue = new int[this.radixs.length];
    }
}

