//package ai.search.square;

import java.util.Arrays;

import aima.search.framework.GoalTest;
import aima.search.framework.StepCostFunction;
import aima.search.framework.HeuristicFunction;


public class SquareState 
	implements GoalTest, StepCostFunction, HeuristicFunction, Cloneable 
{


	// moves
	static public final String up = "Up";
	static public final String down = "Down";
	static public final String left = "Left";
	static public final String right = "Right";
	static public final String ne = "NorthEast";
	static public final String se = "SouthEast";
	static public final String sw = "SouthWest";
	static public final String nw = "NorthWest";
	
	static public enum actions {UP, DOWN, LEFT, RIGHT, NE, SE, SW, NW};
	
	
	
/*****************************************************************************
 * Description of the state of the problem
/*****************************************************************************/
	
	private int[][] myState; 	//valori celle 
	private int lastXPos;		//ultima coordinata X cella visitata dall'agente
	private int lastYPos;		//ultima coordinata Y cella visitata dall'agente
	private int assignedCells;	//n. celle != 0
	private int dim;			//n. righe o colonne 
	
 
	
	
	
/*****************************************************************************
 * CONSTRUCTORS	
/*****************************************************************************/
	/*
	 * Default constructor.
	 * 
	 * It initializes the problem in the classic configuration: all zeros except
	 * the box in position 0,0.
	 * 
	 * The intended meaning is that if the value of the cell is zero, then
	 * the cell has not been assigned (yet).
	 */
	public SquareState(int dim) {
		this.dim = dim;
		this.myState = new int[dim][dim];
		for (int i=0; i<dim; i++)
			for (int j=0; j<dim; j++)
				this.myState[i][j] = 0;
		this.myState[0][0] = 1;	//unico valore assegnato
		//l'agente parte dalla cella (0,0)
		this.lastXPos = 0;		
		this.lastYPos = 0;		
		this.assignedCells = 1;
	}

	
	
	
	
	
	
/*****************************************************************************
* Methods for the interface GoalTest
/*****************************************************************************/
	/*
	 * Very simple test, naive: I check only if all the boxes have an assigned value...
	 * Very easy to fake !!!!!
	 */
	public boolean isGoalState(Object state) {
		if (state instanceof SquareState) {
			SquareState testState = (SquareState) state;
			for (int i=0; i<this.dim; i++)
				for (int j=0; j<this.dim; j++)
					if (testState.myState[i][j] == 0)
						return false;
			System.out.println("GOAL:\n" + testState.toString());
			return true;
		}
		else
			return false;
	};
 
 
 
 

/*****************************************************************************
* Methods for the interface StepCostFunction
/*****************************************************************************/
	
 	public Double calculateStepCost(Object fromState, Object toState, String action) {
 		return new Double(1);
 	};
 	
 


/*****************************************************************************
* Methods for the interface HeuristicFunction
/*****************************************************************************/
 	/*
 	 * Naive heuristic: count the number of unassigned cells 
 	 */
	public double getHeuristicValue(Object state) {
		if (state instanceof SquareState) {
 			SquareState testState = (SquareState) state;
 			int hVal = this.dim*this.dim - testState.assignedCells;
 			return hVal;
 		}
 		else return Integer.MAX_VALUE;
	}

/*	public double h(Object state) {
		return this.getHeuristicValue(state);
	}
*/
 
 
/*****************************************************************************
* Generic Methods
/*****************************************************************************/
	/*	public int hashCode() {
		return 0;
	}

 	public boolean equals(Object o1) {
 		SquareState temp = (SquareState) o1;
 		for (int i=0; i<this.dim; i++)
 			for (int j=0; j<this.dim; j++)
 				if (this.myState[i][j] != temp.myState[i][j])
 					return false;
 		return true; 		
 	}
	*/
 	
 	//stampa il quadrato per righe
 	public String toString() {
 		String result = "[\n";
 		for (int i=0; i<this.dim; i++) {
 			for (int j=0; j<this.dim; j++) {
 				result = result + " " + this.myState[i][j] + ",";
 			}
 			result = result + "\n";
 		}
 		result = result + "]";
 		return result;
	}
 	
 	public int getValue(int xPos, int yPos) {
 		return this.myState[xPos][yPos];
 	}
 	
 	//esegue la mossa "action" passata come parametro, di valore compreso nel set della variabile enumerativa actions della classe SquareState
 	//la mossa  eseguita sullo stato corrente (cf. theState.applyAction all'interno di getSuccessors()) e restituisce una nuova istanza SquareState 
 	public SquareState applyAction(SquareState.actions action) {
 		try {
 			//copia in result lo stato corrente (this)
 			SquareState result = (SquareState) this.clone();
 			if (action == SquareState.actions.RIGHT) {
 				//spostamento a dx saltando 2 celle: X si incrementa di 3, Y rimane invariata
 				//nella nuova cella (lastXPos+3,lastYPos) scrivo il valore della cella da cui l'agente proviene (lastXPos,lastYPos) incrementato di 1
 				//il valore delle celle  memorizzato nell'attributo (vettore bidim.) myState[][]
 	 	 		result.myState[result.lastYPos][result.lastXPos+3] = result.myState[result.lastYPos][result.lastXPos] + 1;
 	 	 		//aggiorno la posizione dell'agente (Y  rimasta invariata)
 	 	 		result.lastXPos = result.lastXPos + 3;
 			}
 			if (action == SquareState.actions.SE) {
 				//lo spostamento in diagonale saltando 1 cella richiede una variazione di +/-2 per entrambe le coordinate 
 	 	 		result.myState[result.lastYPos+2][result.lastXPos+2] = result.myState[result.lastYPos][result.lastXPos] + 1;
 	 	 		result.lastXPos = result.lastXPos +2;
 	 	 		result.lastYPos = result.lastYPos +2;
 			}
 			if (action == SquareState.actions.DOWN) {
 				result.myState[result.lastYPos+3][result.lastXPos] = result.myState[result.lastYPos][result.lastXPos] + 1;
 				result.lastYPos = result.lastYPos + 3;
 			}
 			if (action == SquareState.actions.SW) {
 	 	 		result.myState[result.lastYPos+2][result.lastXPos-2] = result.myState[result.lastYPos][result.lastXPos] + 1;
 	 	 		result.lastXPos = result.lastXPos -2;
 	 	 		result.lastYPos = result.lastYPos +2;
 			}
 			if (action == SquareState.actions.LEFT) {
 				result.myState[result.lastYPos][result.lastXPos-3] = result.myState[result.lastYPos][result.lastXPos] + 1;
 				result.lastXPos = result.lastXPos - 3;
 			}
 			if (action == SquareState.actions.NW) {
 	 	 		result.myState[result.lastYPos-2][result.lastXPos-2] = result.myState[result.lastYPos][result.lastXPos] + 1;
 	 	 		result.lastXPos = result.lastXPos -2;
 	 	 		result.lastYPos = result.lastYPos -2;
 			}
 			if (action == SquareState.actions.UP) {
 				result.myState[result.lastYPos-3][result.lastXPos] = result.myState[result.lastYPos][result.lastXPos] + 1;
 				result.lastYPos = result.lastYPos - 3; 
 			}
 			if (action == SquareState.actions.NE) {
 	 	 		result.myState[result.lastYPos-2][result.lastXPos+2] = result.myState[result.lastYPos][result.lastXPos] + 1;
 	 	 		result.lastXPos = result.lastXPos +2;
 	 	 		result.lastYPos = result.lastYPos -2;
 			}
 			return result;
 		} catch (Exception e) {
 			e.printStackTrace();
 		}
 		return null;
 	}

 	//testa se lo spostamento in unaltra cella (parametro action)  possibile 
 	public boolean isActionAllowed(SquareState.actions action) {
 		if (action == SquareState.actions.UP) {
 			    /*1) lo spostamento verso l'alto (up) richiede di decrementare Y di 3 (per saltare 2 celle). 
 			     * Potrebbe quindi portare fuori dal quadrato se l'agente si trova in una cella con coordinata lastYPos<3 
 			     * (si supponga che l'origine degli assi sia nella cella (0,0) e che gli assi si sovrappongano
 			     alla riga 0 e alla colonna 0)
 			     2) verifico che la cella d'arrivo (lastXPos,lastYPos-3) sia ancora nulla*/
 				if (this.lastYPos >=3 && this.myState[this.lastYPos-3][this.lastXPos] == 0)
 					return true;
 				else
 					return false; 
 		}
 		if (action == SquareState.actions.DOWN) {
 			/*lo spostamento verso il basso (down) richiede di incrementare Y di 3 (per saltare 2 celle). L'agente deve quindi
 			trovarsi almeno a distanza 3 dal bordo inferiore del quadrato (celle di coordinata dim) */
 			if (this.lastYPos < this.dim-3 && this.myState[this.lastYPos+3][this.lastXPos] == 0)
					return true;
				else
					return false;
 		}
 		if (action == SquareState.actions.LEFT) {
 			if (this.lastXPos >=3 && this.myState[this.lastYPos][this.lastXPos-3] == 0)
					return true;
				else
					return false;
 		}
 		if (action == SquareState.actions.RIGHT) {
 			if (this.lastXPos < this.dim-3 && this.myState[this.lastYPos][this.lastXPos+3] == 0)
					return true;
				else
					return false;
 		}
 		if (action == SquareState.actions.NE) {
 			/*lo spostamento verso nord-est richiede di verificare:
 			- di non oltrepassare il lato superiore del quadrato (lastYPos >=2)
 			- di non oltrepassare il lato destro del quadrato (lastXPos < dim-2)
 			*/
 			if (this.lastYPos >=2 && this.lastXPos < this.dim-2 && this.myState[this.lastYPos-2][this.lastXPos+2] == 0)
					return true;
				else
					return false;
 		}
 		if (action == SquareState.actions.SE) {
 			if (this.lastYPos < this.dim-2 && this.lastXPos < this.dim-2 && this.myState[this.lastYPos+2][this.lastXPos+2] == 0)
				return true;
			else
				return false;
 			}
 		if (action == SquareState.actions.SW) {
 			if (this.lastYPos < this.dim-2 && this.lastXPos >= 2 && this.myState[this.lastYPos+2][this.lastXPos-2] == 0)
				return true;
			else
				return false;
 			}
 		if (action == SquareState.actions.NW) {
 			if (this.lastYPos >=2 && this.lastXPos >= 2 && this.myState[this.lastYPos-2][this.lastXPos-2] == 0)
				return true;
			else
				return false;
 			}
 			
 		return false;
 	}
 	
 	/* A class implements the Cloneable interface to indicate to the Object.clone() method that it is legal for that 
 	 * method to make a field-for-field copy of instances of that class. By convention, classes that implement this 
 	 * interface should override Object.clone (which is protected) with a public method. 
 	 * @see java.lang.Object#clone()
 	 */
 public Object clone() throws CloneNotSupportedException {
 		SquareState result = (SquareState) super.clone();
 		result.myState = new int[this.dim][this.dim];
 		for (int i=0; i<this.dim; i++)
 			for (int j=0; j<this.dim; j++)
 				result.myState[i][j] = this.myState[i][j];
 		return result;
 	}
 	
}
