//package ai.search.square;

import java.util.List;
import java.util.ArrayList;


import aima.search.framework.Successor;
import aima.search.framework.SuccessorFunction;




public class SquareSuccessorFunction implements SuccessorFunction {


	
/*****************************************************************************
* CONSTRUCTORS
/*****************************************************************************/
	
	public SquareSuccessorFunction() {
	};
	
	
	
/*****************************************************************************
* INTERFACE METHODS
/*****************************************************************************/
	public List getSuccessors(Object state) {
		
		List result = new ArrayList();
		
		if (state instanceof SquareState) {
			SquareState theState = (SquareState) state;
			
			/* per ognuna delle direzioni di spostamento verifico che la mossa sia consentita prima 
			 * di applicarla (con applyAction). Il primo parametro del costruttore Successor  la variabile stringa identificativa dell'azione
			 * (definita in SquareState.java), necessaria per stampare la sequenza di azioni che ha generato la soluzione.
			 * add() aggiunge alla lista uno stato successore (1) raggiunto con la mossa indicata nel primo argomento di Successor() e (2) generato
			 * dal metodo applyAction che modifica lo stato corrente tramite la mossa.*/
			
	 		if (theState.isActionAllowed(SquareState.actions.UP))
	 			result.add(new Successor( SquareState.up, theState.applyAction(SquareState.actions.UP)));
	 		
	 		if (theState.isActionAllowed(SquareState.actions.DOWN))
	 			result.add(new Successor( SquareState.down, theState.applyAction(SquareState.actions.DOWN)));
	 		
	 		if (theState.isActionAllowed(SquareState.actions.LEFT))
	 			result.add(new Successor( SquareState.left, theState.applyAction(SquareState.actions.LEFT)));
	 		
	 		if (theState.isActionAllowed(SquareState.actions.RIGHT))
	 			result.add(new Successor( SquareState.right, theState.applyAction(SquareState.actions.RIGHT)));
	 		
	 		if (theState.isActionAllowed(SquareState.actions.NE))
	 			result.add(new Successor( SquareState.ne, theState.applyAction(SquareState.actions.NE)));
	 		
	 		if (theState.isActionAllowed(SquareState.actions.SE))
	 			result.add(new Successor( SquareState.se, theState.applyAction(SquareState.actions.SE)));
	 		if (theState.isActionAllowed(SquareState.actions.SW))
	 			result.add(new Successor( SquareState.sw, theState.applyAction(SquareState.actions.SW)));
	 		
	 		if (theState.isActionAllowed(SquareState.actions.NW))
	 			result.add(new Successor( SquareState.nw, theState.applyAction(SquareState.actions.NW)));
		}
		return result;
	}
	
}
