/*
 * Decompiled with CFR 0.152.
 */
package aima.gui.applications.search.map;

import aima.gui.applications.search.map.MapAgentModel;
import aima.gui.framework.AgentAppFrame;
import aima.gui.framework.AgentView;
import aima.search.framework.SearchFactory;
import aima.search.map.Map;
import aima.search.map.Point2D;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

public class MapAgentFrame
extends AgentAppFrame {
    public static String SCENARIO_SEL = "ScenarioSelection";
    public static String DESTINATION_SEL = "DestinationSelection";
    public static String AGENT_SEL = "AgentSelection";
    public static String SEARCH_SEL = "SearchSelection";
    public static String SEARCH_MODE_SEL = "SearchModeSelection";
    public static String HEURISTIC_SEL = "HeuristicSelection";

    public MapAgentFrame() {
        this.setSelectors(new String[]{SCENARIO_SEL, DESTINATION_SEL, AGENT_SEL, SEARCH_SEL, SEARCH_MODE_SEL, HEURISTIC_SEL}, new String[]{"Select Scenario", "Select Destinations", "Select Agent", "Select Search Strategy", "Select Search Mode", "Select Heuristic"});
        this.setSelectorItems(SEARCH_SEL, SearchFactory.getInstance().getSearchStrategyNames(), 5);
        this.setSelectorItems(SEARCH_MODE_SEL, SearchFactory.getInstance().getSearchModeNames(), 0);
        this.setAgentView(new MapAgentView());
        this.setSplitPaneResizeWeight(0.75);
        this.setUpdateDelay(500);
        this.setSize(1000, 700);
    }

    private static class Roadblock {
        Point2D pos1;
        Point2D pos2;
        boolean inEnvMap;
        boolean inAgentMap;

        private Roadblock(Point2D pos1, Point2D pos2, boolean inEnvMap, boolean inAgentMap) {
            this.pos1 = pos1;
            this.pos2 = pos2;
            this.inEnvMap = inEnvMap;
            this.inAgentMap = inAgentMap;
        }
    }

    class MapAgentView
    extends AgentView {
        MapAgentView() {
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            MapAgentModel maModel = (MapAgentModel)this.model;
            if (maModel != null && !maModel.isEmpty()) {
                Graphics2D g2 = (Graphics2D)g;
                this.adjustTransformation();
                this.paintMap(g2);
                this.paintTour(g2);
                for (String loc : maModel.getLocations()) {
                    this.paintLoc(g2, loc);
                }
            }
        }

        private void adjustTransformation() {
            MapAgentModel maModel = (MapAgentModel)this.model;
            List<String> locs = maModel.getLocations();
            double minX = Double.POSITIVE_INFINITY;
            double minY = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            double maxY = Double.NEGATIVE_INFINITY;
            for (String loc : locs) {
                Point2D xy = maModel.getLocCoords(loc);
                if (xy.getX() < minX) {
                    minX = xy.getX();
                }
                if (xy.getY() < minY) {
                    minY = xy.getY();
                }
                if (xy.getX() > maxX) {
                    maxX = xy.getX();
                }
                if (!(xy.getY() > maxY)) continue;
                maxY = xy.getY();
            }
            this.setBorder(20, 20, 20, 100);
            this.adjustTransformation(minX, minY, maxX, maxY);
        }

        private void paintMap(Graphics2D g2) {
            MapAgentModel maModel = (MapAgentModel)this.model;
            Map envMap = maModel.getEnvMap();
            Map agentMap = maModel.getAgentMap();
            ArrayList<Roadblock> roadblocks = new ArrayList<Roadblock>();
            for (String l1 : maModel.getLocations()) {
                Point2D pt1 = maModel.getLocCoords(l1);
                List<String> linkedLocs = envMap.getLocationsLinkedTo(l1);
                for (String l2 : agentMap.getLocationsLinkedTo(l1)) {
                    if (linkedLocs.contains(l2)) continue;
                    linkedLocs.add(l2);
                }
                for (String l2 : linkedLocs) {
                    Point2D pt2 = maModel.getLocCoords(l2);
                    g2.setColor(Color.lightGray);
                    g2.drawLine(this.x(pt1), this.y(pt1), this.x(pt2), this.y(pt2));
                    boolean blockedInEnv = !envMap.getLocationsLinkedTo(l2).contains(l1);
                    boolean blockedInAgent = !agentMap.getLocationsLinkedTo(l2).contains(l1);
                    roadblocks.add(new Roadblock(pt1, pt2, blockedInEnv, blockedInAgent));
                    if (!blockedInEnv || !blockedInAgent) continue;
                    boolean blockedInEnvOtherDir = !envMap.getLocationsLinkedTo(l1).contains(l2);
                    boolean blockedInAgentOtherDir = !agentMap.getLocationsLinkedTo(l1).contains(l2);
                    roadblocks.add(new Roadblock(pt2, pt1, blockedInEnvOtherDir, blockedInAgentOtherDir));
                }
            }
            for (Roadblock block : roadblocks) {
                this.paintRoadblock(g2, block);
            }
        }

        private void paintTour(Graphics2D g2) {
            MapAgentModel maModel = (MapAgentModel)this.model;
            Point2D lastPt = null;
            g2.setColor(Color.red);
            for (String loc : maModel.getTourHistory()) {
                Point2D pt = maModel.getLocCoords(loc);
                if (pt != null && lastPt != null) {
                    g2.drawLine(this.x(pt), this.y(pt), this.x(lastPt), this.y(lastPt));
                }
                lastPt = pt;
            }
        }

        private void paintRoadblock(Graphics2D g2, Roadblock block) {
            if (block.inEnvMap || block.inAgentMap) {
                int x = (int)(0.2 * (double)this.x(block.pos1) + 0.8 * (double)this.x(block.pos2) - 4.0);
                int y = (int)(0.2 * (double)this.y(block.pos1) + 0.8 * (double)this.y(block.pos2) - 4.0);
                if (!block.inAgentMap) {
                    g2.setColor(Color.blue);
                } else if (!block.inEnvMap) {
                    g2.setColor(Color.red);
                } else {
                    g2.setColor(Color.lightGray);
                }
                g2.fillRect(x, y, 9, 9);
            }
        }

        private void paintLoc(Graphics2D g2, String loc) {
            MapAgentModel maModel = (MapAgentModel)this.model;
            Point2D pt = maModel.getLocCoords(loc);
            if (pt != null) {
                int x = this.x(pt);
                int y = this.y(pt);
                String info = "";
                List<String> history = maModel.getTourHistory();
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int i = 0; i < history.size(); ++i) {
                    if (!history.get(i).equals(loc)) continue;
                    list.add(i + 1);
                }
                if (!list.isEmpty()) {
                    info = list.toString();
                }
                if (maModel.hasObjects(loc)) {
                    g2.setColor(Color.green);
                    g2.fillOval(x - 5, y - 5, 10, 10);
                }
                if (maModel.isStart(loc)) {
                    g2.setColor(Color.red);
                    g2.fillOval(x - 7, y - 7, 14, 14);
                }
                if (!history.isEmpty() && loc.equals(history.get(history.size() - 1))) {
                    g2.setColor(Color.red);
                    g2.fillOval(x - 4, y - 4, 8, 8);
                }
                if (maModel.hasInfos(loc)) {
                    g2.setColor(Color.blue);
                    g2.drawString("i", x, y + 12);
                }
                if (maModel.isDestination(loc)) {
                    g2.setColor(Color.green);
                } else if (history.contains(loc)) {
                    g2.setColor(Color.black);
                } else {
                    g2.setColor(Color.gray);
                }
                g2.drawString(loc + info, x, y);
            }
        }
    }
}

