/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.inference.proof;

import aima.logic.fol.inference.proof.AbstractProofStep;
import aima.logic.fol.inference.proof.ProofStep;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ProofStepClauseBinaryResolvent
extends AbstractProofStep {
    private List<ProofStep> predecessors = new ArrayList<ProofStep>();
    private Clause resolvent = null;
    private Clause parent1;
    private Clause parent2 = null;
    private Map<Variable, Term> subst = null;
    private Map<Variable, Term> renameSubst = null;

    public ProofStepClauseBinaryResolvent(Clause resolvent, Clause parent1, Clause parent2, Map<Variable, Term> subst, Map<Variable, Term> renameSubst) {
        this.resolvent = resolvent;
        this.parent1 = parent1;
        this.parent2 = parent2;
        this.subst = subst;
        this.renameSubst = renameSubst;
        this.predecessors.add(parent1.getProofStep());
        this.predecessors.add(parent2.getProofStep());
    }

    @Override
    public List<ProofStep> getPredecessorSteps() {
        return Collections.unmodifiableList(this.predecessors);
    }

    @Override
    public String getProof() {
        return this.resolvent.toString();
    }

    @Override
    public String getJustification() {
        int highStep;
        int lowStep = this.parent1.getProofStep().getStepNumber();
        if (lowStep > (highStep = this.parent2.getProofStep().getStepNumber())) {
            lowStep = highStep;
            highStep = this.parent1.getProofStep().getStepNumber();
        }
        return "Resolution: " + lowStep + "," + highStep + " " + this.subst + ", " + this.renameSubst;
    }
}

