/*
 * Decompiled with CFR 0.152.
 */
package aima.probability;

import aima.probability.Randomizer;
import aima.probability.reasoning.HiddenMarkovModel;
import aima.probability.reasoning.Particle;
import aima.probability.reasoning.ParticleSet;
import aima.util.Matrix;
import aima.util.Util;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class RandomVariable {
    private String name;
    private Hashtable<String, Double> distribution;
    private List<String> states;

    public RandomVariable(List<String> states) {
        this("HiddenState", states);
    }

    public RandomVariable(String name, List<String> states) {
        this.name = name;
        this.states = states;
        this.distribution = new Hashtable();
        int numberOfStates = states.size();
        double initialProbability = 1.0 / (double)numberOfStates;
        for (String s : states) {
            this.distribution.put(s, initialProbability);
        }
    }

    private RandomVariable(String name, List<String> states, Hashtable<String, Double> distribution) {
        this.name = name;
        this.states = states;
        this.distribution = distribution;
    }

    public void setProbabilityOf(String state, Double probability) {
        if (!this.states.contains(state)) {
            throw new RuntimeException(state + "  is an invalid state");
        }
        this.distribution.put(state, probability);
    }

    public double getProbabilityOf(String state) {
        if (this.states.contains(state)) {
            return this.distribution.get(state);
        }
        throw new RuntimeException(state + "  is an invalid state");
    }

    public List<String> states() {
        return this.states;
    }

    public RandomVariable duplicate() {
        Hashtable<String, Double> probs = new Hashtable<String, Double>();
        for (String key : this.distribution.keySet()) {
            probs.put(key, this.distribution.get(key));
        }
        return new RandomVariable(this.name, this.states, probs);
    }

    public void normalize() {
        ArrayList<Double> probs = new ArrayList<Double>();
        for (String s : this.states) {
            probs.add(this.distribution.get(s));
        }
        List<Double> newProbs = Util.normalize(probs);
        for (int i = 0; i < this.states.size(); ++i) {
            this.distribution.put(this.states.get(i), newProbs.get(i));
        }
    }

    public Matrix asMatrix() {
        Matrix m = new Matrix(this.states.size(), 1);
        for (int i = 0; i < this.states.size(); ++i) {
            m.set(i, 0, this.distribution.get(this.states.get(i)));
        }
        return m;
    }

    public void updateFrom(Matrix aMatrix) {
        for (int i = 0; i < this.states.size(); ++i) {
            this.distribution.put(this.states.get(i), aMatrix.get(i, 0));
        }
    }

    public RandomVariable createUnitBelief() {
        RandomVariable result = this.duplicate();
        for (String s : this.states()) {
            result.setProbabilityOf(s, 1.0);
        }
        return result;
    }

    public String toString() {
        return this.asMatrix().toString();
    }

    public ParticleSet toParticleSet(HiddenMarkovModel hmm, Randomizer randomizer, int numberOfParticles) {
        ParticleSet result = new ParticleSet(hmm);
        for (int i = 0; i < numberOfParticles; ++i) {
            double rvalue = randomizer.nextDouble();
            String state = this.getStateForRandomNumber(rvalue);
            result.add(new Particle(state, 0.0));
        }
        return result;
    }

    private String getStateForRandomNumber(double rvalue) {
        double total = 0.0;
        for (String s : this.states) {
            if (!((total += this.distribution.get(s).doubleValue()) >= rvalue)) continue;
            return s;
        }
        throw new RuntimeException("cannot handle " + rvalue);
    }
}

