/*
 * Decompiled with CFR 0.152.
 */
package aima.probability.reasoning;

import aima.util.Matrix;
import aima.util.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TransitionModel {
    private Table<String, String, Double> table;
    private List<String> states;

    public TransitionModel(List<String> states, List<String> actions2) {
        this.states = states;
        ArrayList<String> state_actions = new ArrayList<String>();
        for (String state : states) {
            for (String action : actions2) {
                state_actions.add(state.concat(action));
            }
        }
        this.table = new Table(state_actions, states);
    }

    public TransitionModel(List<String> states) {
        this(states, Arrays.asList("do_nothing"));
    }

    public void setTransitionProbability(String startState, String endState, Double probability) {
        String start_state_plus_action = startState.concat("do_nothing");
        this.table.set(start_state_plus_action, endState, probability);
    }

    public void setTransitionProbability(String startState, String action, String endState, Double probability) {
        String start_state_plus_action = startState.concat(action);
        this.table.set(start_state_plus_action, endState, probability);
    }

    public double get(String old_state_action, String newState) {
        return this.table.get(old_state_action, newState);
    }

    public Matrix asMatrix(String action) {
        Matrix transitionMatrix = new Matrix(this.states.size(), this.states.size());
        for (int i = 0; i < this.states.size(); ++i) {
            String oldState = this.states.get(i);
            String old_state_action = oldState.concat(action);
            for (int j = 0; j < this.states.size(); ++j) {
                String newState = this.states.get(j);
                double transitionProbability = this.get(old_state_action, newState);
                transitionMatrix.set(i, j, transitionProbability);
            }
        }
        return transitionMatrix;
    }

    public Matrix asMatrix() {
        return this.asMatrix("do_nothing");
    }

    public Matrix unitMatrix() {
        Matrix m = this.asMatrix();
        return Matrix.identity(m.getRowDimension(), m.getColumnDimension());
    }

    public String getStateForProbability(String oldState, double probability) {
        return this.getStateForGivenActionAndProbability(oldState, "do_nothing", probability);
    }

    public String getStateForProbability(String oldState, String action, double probability) {
        return this.getStateForGivenActionAndProbability(oldState, action, probability);
    }

    public String getStateForGivenActionAndProbability(String oldState, String action, double probability) {
        String state_action = oldState + action;
        double total = 0.0;
        for (String state : this.states) {
            if (!((total += this.table.get(state_action, state).doubleValue()) >= probability)) continue;
            return state;
        }
        return null;
    }
}

