/*
 * Decompiled with CFR 0.152.
 */
package aima.search.csp;

import aima.search.csp.Assignment;
import aima.search.csp.Constraint;
import aima.search.csp.Domain;
import aima.util.Util;
import java.util.ArrayList;
import java.util.List;

public class CSP {
    private Domain domains;
    private Constraint constraints;
    private List<String> variables;

    public CSP(List<String> variables, Constraint constraints) {
        this.variables = variables;
        this.domains = new Domain(variables);
        this.constraints = constraints;
    }

    public CSP(List<String> variables, Constraint constraints, Domain domains) {
        this.variables = variables;
        this.domains = domains;
        this.constraints = constraints;
    }

    public List defaultOrderDomainOf(String variable) {
        return this.domains.getDomainOf(variable);
    }

    public Assignment backTrackingSearch() {
        return this.recursiveBackTrackingSearch(new Assignment(this.variables));
    }

    private Assignment recursiveBackTrackingSearch(Assignment anAssignment) {
        if (anAssignment.isComplete()) {
            return anAssignment;
        }
        String variable = anAssignment.selectFirstUnassignedVariable();
        List domainValues = this.defaultOrderDomainOf(variable);
        for (int i = 0; i < domainValues.size(); ++i) {
            Object value = domainValues.get(i);
            if (!this.constraints.isSatisfiedWith(anAssignment, variable, value)) continue;
            anAssignment.setAssignment(variable, value);
            Assignment result = this.recursiveBackTrackingSearch(anAssignment);
            if (result != null) {
                return result;
            }
            anAssignment.remove(variable);
        }
        return null;
    }

    public Assignment mcSearch(int maxSteps) {
        Assignment randomAssignment = this.generateRandomAssignment();
        for (int i = 0; i < maxSteps; ++i) {
            if (randomAssignment.satisfies(this.constraints)) {
                return randomAssignment;
            }
            String conflictedVariable = Util.selectRandomlyFromList(randomAssignment.getConflictedVariables(this.constraints));
            Object minConflictValue = randomAssignment.getMinimumConflictingValueFor(conflictedVariable, this.domains.getDomainOf(conflictedVariable), this.constraints);
            randomAssignment.setAssignment(conflictedVariable, minConflictValue);
        }
        return null;
    }

    private Assignment generateRandomAssignment() {
        ArrayList<String> vars = new ArrayList<String>();
        for (int i = 0; i < this.variables.size(); ++i) {
            vars.add(this.variables.get(i));
        }
        Assignment assignment = new Assignment(vars);
        for (int i = 0; i < this.variables.size(); ++i) {
            String variable = this.variables.get(i);
            Object randomValue = Util.selectRandomlyFromList(this.domains.getDomainOf(variable));
            assignment.setAssignment(variable, randomValue);
        }
        return assignment;
    }
}

