/*
 * Decompiled with CFR 0.152.
 */
package aima.search.framework;

import aima.util.AbstractQueue;
import java.util.List;

public class Node {
    private Object state;
    private Node parent;
    private String action;
    Double pathCost;
    private int depth;
    private Double stepCost;

    public Node(Object state) {
        this.state = state;
        this.depth = 0;
        this.stepCost = new Double(0.0);
        this.pathCost = new Double(0.0);
    }

    public Node(Node parent, Object state) {
        this(state);
        this.parent = parent;
        this.depth = parent.getDepth() + 1;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isRootNode() {
        return this.parent == null;
    }

    public Node getParent() {
        return this.parent;
    }

    public List<Node> getPathFromRoot() {
        Node current = this;
        AbstractQueue queue = new AbstractQueue();
        while (!current.isRootNode()) {
            queue.addToFront(current);
            current = current.getParent();
        }
        queue.addToFront(current);
        return queue.asList();
    }

    public Object getState() {
        return this.state;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public void setStepCost(Double stepCost) {
        this.stepCost = stepCost;
    }

    public void addToPathCost(Double stepCost) {
        this.pathCost = new Double(this.parent.pathCost + stepCost);
    }

    public double getPathCost() {
        return this.pathCost;
    }

    public double getStepCost() {
        return this.stepCost;
    }

    public String toString() {
        return this.getState().toString();
    }
}

