/*
 * Decompiled with CFR 0.152.
 */
package aima.search.uninformed;

import aima.search.framework.BidirectionalProblem;
import aima.search.framework.GraphSearch;
import aima.search.framework.Metrics;
import aima.search.framework.Node;
import aima.search.framework.Problem;
import aima.search.framework.Search;
import aima.search.framework.SearchUtils;
import aima.search.framework.Successor;
import aima.search.nodestore.CachedStateNodeStore;
import aima.search.nodestore.FIFONodeStore;
import java.util.ArrayList;
import java.util.List;

public class BidirectionalSearch
implements Search {
    protected Metrics metrics;
    private SearchOutcome searchOutcome = SearchOutcome.PATH_NOT_FOUND;
    private static final String NODES_EXPANDED = "nodesExpanded";
    private static final String QUEUE_SIZE = "queueSize";
    private static final String MAX_QUEUE_SIZE = "maxQueueSize";
    private static final String PATH_COST = "pathCost";

    public BidirectionalSearch() {
        this.metrics = new Metrics();
    }

    @Override
    public List<String> search(Problem p) throws Exception {
        assert (p instanceof BidirectionalProblem);
        this.searchOutcome = SearchOutcome.PATH_NOT_FOUND;
        this.clearInstrumentation();
        Problem op = ((BidirectionalProblem)((Object)p)).getOriginalProblem();
        Problem rp = ((BidirectionalProblem)((Object)p)).getReverseProblem();
        CachedStateNodeStore opFringe = new CachedStateNodeStore(new FIFONodeStore());
        CachedStateNodeStore rpFringe = new CachedStateNodeStore(new FIFONodeStore());
        GraphSearch ogs = new GraphSearch();
        GraphSearch rgs = new GraphSearch();
        ogs.clearInstrumentation();
        rgs.clearInstrumentation();
        Node opNode = new Node(op.getInitialState());
        Node rpNode = new Node(rp.getInitialState());
        opFringe.add(opNode);
        rpFringe.add(rpNode);
        this.setQueueSize(opFringe.size() + rpFringe.size());
        this.setNodesExpanded(ogs.getNodesExpanded() + rgs.getNodesExpanded());
        while (!opFringe.isEmpty() || !rpFringe.isEmpty()) {
            List<String> actions2;
            if (!opFringe.isEmpty()) {
                opNode = opFringe.remove();
                ogs.addExpandedNodesToFringe(opFringe, opNode, op);
            } else {
                opNode = null;
            }
            if (!rpFringe.isEmpty()) {
                rpNode = rpFringe.remove();
                rgs.addExpandedNodesToFringe(rpFringe, rpNode, rp);
            } else {
                rpNode = null;
            }
            this.setQueueSize(opFringe.size() + rpFringe.size());
            this.setNodesExpanded(ogs.getNodesExpanded() + rgs.getNodesExpanded());
            if (null != opNode && null != rpNode) {
                List<String> actions3;
                Node popNode = null;
                Node prpNode = null;
                if (opFringe.containsNodeBasedOn(rpNode.getState())) {
                    popNode = opFringe.getNodeBasedOn(rpNode.getState());
                    prpNode = rpNode;
                } else if (rpFringe.containsNodeBasedOn(opNode.getState())) {
                    popNode = opNode;
                    prpNode = rpFringe.getNodeBasedOn(opNode.getState());
                } else if (opNode.getState().equals(rpNode.getState())) {
                    popNode = opNode;
                    prpNode = rpNode;
                }
                if (null != popNode && null != prpNode && null != (actions3 = this.retrieveActions(op, rp, popNode, prpNode))) {
                    return actions3;
                }
            }
            if (null != opNode && op.isGoalState(opNode.getState())) {
                return this.retrieveActions(op, rp, opNode, null);
            }
            if (null == rpNode || !rp.isGoalState(rpNode.getState()) || null == (actions2 = this.retrieveActions(op, rp, null, rpNode))) continue;
            return actions2;
        }
        return new ArrayList<String>();
    }

    public SearchOutcome getSearchOutcome() {
        return this.searchOutcome;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    public void clearInstrumentation() {
        this.metrics.set(NODES_EXPANDED, 0);
        this.metrics.set(QUEUE_SIZE, 0);
        this.metrics.set(MAX_QUEUE_SIZE, 0);
        this.metrics.set(PATH_COST, 0.0);
    }

    public int getNodesExpanded() {
        return this.metrics.getInt(NODES_EXPANDED);
    }

    public void setNodesExpanded(int nodesExpanded) {
        this.metrics.set(NODES_EXPANDED, nodesExpanded);
    }

    public int getQueueSize() {
        return this.metrics.getInt(QUEUE_SIZE);
    }

    public void setQueueSize(int queueSize) {
        this.metrics.set(QUEUE_SIZE, queueSize);
        int maxQSize = this.metrics.getInt(MAX_QUEUE_SIZE);
        if (queueSize > maxQSize) {
            this.metrics.set(MAX_QUEUE_SIZE, queueSize);
        }
    }

    public int getMaxQueueSize() {
        return this.metrics.getInt(MAX_QUEUE_SIZE);
    }

    public double getPathCost() {
        return this.metrics.getDouble(PATH_COST);
    }

    public void setPathCost(Double pathCost) {
        this.metrics.set(PATH_COST, pathCost);
    }

    private List<String> retrieveActions(Problem op, Problem rp, Node originalPath, Node reversePath) {
        ArrayList<String> actions2 = new ArrayList();
        if (null == reversePath) {
            this.setPathCost(originalPath.getPathCost());
            this.searchOutcome = SearchOutcome.PATH_FOUND_FROM_ORIGINAL_PROBLEM;
            actions2 = SearchUtils.actionsFromNodes(originalPath.getPathFromRoot());
        } else {
            ArrayList<Node> nodePath = new ArrayList<Node>();
            Object originalState = null;
            if (null != originalPath) {
                nodePath.addAll(originalPath.getPathFromRoot());
                originalState = originalPath.getState();
            }
            if (!op.isGoalState(reversePath.getState())) {
                List<Node> rpath = reversePath.getPathFromRoot();
                for (int i = rpath.size() - 1; i >= 0; --i) {
                    if (rpath.get(i).getState().equals(originalState)) continue;
                    nodePath.add(rpath.get(i));
                }
            }
            if (!this.canTraversePathFromOriginalProblem(op, nodePath, actions2)) {
                return null;
            }
            this.searchOutcome = null == originalPath ? SearchOutcome.PATH_FOUND_FROM_REVERSE_PROBLEM : (this.canConnectToOriginalFromReverse(rp, originalPath, reversePath) ? SearchOutcome.PATH_FOUND_BETWEEN_PROBLEMS : SearchOutcome.PATH_FOUND_FROM_ORIGINAL_PROBLEM);
        }
        return actions2;
    }

    private boolean canTraversePathFromOriginalProblem(Problem op, List<Node> path, List<String> actions2) {
        boolean rVal = true;
        double pc = 0.0;
        for (int i = 0; i < path.size() - 1; ++i) {
            Object currentState = path.get(i).getState();
            Object nextState = path.get(i + 1).getState();
            List successors = op.getSuccessorFunction().getSuccessors(currentState);
            boolean found = false;
            for (Successor s : successors) {
                if (!nextState.equals(s.getState())) continue;
                found = true;
                pc += op.getStepCostFunction().calculateStepCost(currentState, nextState, s.getAction()).doubleValue();
                actions2.add(s.getAction());
                break;
            }
            if (found) continue;
            rVal = false;
            break;
        }
        this.setPathCost(true == rVal ? pc : 0.0);
        return rVal;
    }

    private boolean canConnectToOriginalFromReverse(Problem rp, Node originalPath, Node reversePath) {
        boolean rVal = true;
        if (!originalPath.isRootNode()) {
            rVal = false;
            List successors = rp.getSuccessorFunction().getSuccessors(reversePath.getState());
            for (Successor s : successors) {
                if (!originalPath.getParent().getState().equals(s.getState())) continue;
                rVal = true;
                break;
            }
        }
        return rVal;
    }

    public static enum SearchOutcome {
        PATH_FOUND_FROM_ORIGINAL_PROBLEM,
        PATH_FOUND_FROM_REVERSE_PROBLEM,
        PATH_FOUND_BETWEEN_PROBLEMS,
        PATH_NOT_FOUND;

    }
}

