/*
 * Decompiled with CFR 0.152.
 */
package aima.test.learningtest;

import aima.learning.framework.DataSet;
import aima.learning.framework.DataSetFactory;
import aima.learning.inductive.DecisionTree;
import aima.learning.learners.DecisionTreeLearner;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class DecisionTreeTest
extends TestCase {
    private static final String YES = "Yes";
    private static final String NO = "No";

    public void testActualDecisionTreeClassifiesRestaurantDataSetCorrectly() throws Exception {
        DecisionTreeLearner learner = new DecisionTreeLearner(DecisionTreeTest.createActualRestaurantDecisionTree(), "Unable to clasify");
        int[] results = learner.test(DataSetFactory.getRestaurantDataSet());
        DecisionTreeTest.assertEquals(12, results[0]);
        DecisionTreeTest.assertEquals(0, results[1]);
    }

    public void testInducedDecisionTreeClassifiesRestaurantDataSetCorrectly() throws Exception {
        DecisionTreeLearner learner = new DecisionTreeLearner(DecisionTreeTest.createInducedRestaurantDecisionTree(), "Unable to clasify");
        int[] results = learner.test(DataSetFactory.getRestaurantDataSet());
        DecisionTreeTest.assertEquals(12, results[0]);
        DecisionTreeTest.assertEquals(0, results[1]);
    }

    public void testStumpCreationForSpecifiedAttributeValuePair() throws Exception {
        DataSet ds = DataSetFactory.getRestaurantDataSet();
        ArrayList<String> unmatchedValues = new ArrayList<String>();
        unmatchedValues.add(NO);
        DecisionTree dt = DecisionTree.getStumpFor(ds, "alternate", YES, YES, unmatchedValues, NO);
        DecisionTreeTest.assertNotNull(dt);
    }

    public void testStumpCreationForDataSet() throws Exception {
        DataSet ds = DataSetFactory.getRestaurantDataSet();
        List<DecisionTree> dt = DecisionTree.getStumpsFor(ds, YES, "Unable to classify");
        DecisionTreeTest.assertEquals(26, dt.size());
    }

    public void testStumpPredictionForDataSet() throws Exception {
        DataSet ds = DataSetFactory.getRestaurantDataSet();
        List<DecisionTree> trees = DecisionTree.getStumpsFor(ds, YES, "Unable to classify");
        ArrayList<String> unmatchedValues = new ArrayList<String>();
        unmatchedValues.add(NO);
        DecisionTree tree = DecisionTree.getStumpFor(ds, "hungry", YES, YES, unmatchedValues, "Unable to Classify");
        DecisionTreeLearner learner = new DecisionTreeLearner(tree, "Unable to Classify");
        int[] result = learner.test(ds);
        DecisionTreeTest.assertEquals(5, result[0]);
        DecisionTreeTest.assertEquals(7, result[1]);
    }

    private static DecisionTree createInducedRestaurantDecisionTree() {
        DecisionTree frisat = new DecisionTree("fri/sat");
        frisat.addLeaf(YES, YES);
        frisat.addLeaf(NO, NO);
        DecisionTree type = new DecisionTree("type");
        type.addLeaf("French", YES);
        type.addLeaf("Italian", NO);
        type.addNode("Thai", frisat);
        type.addLeaf("Burger", YES);
        DecisionTree hungry = new DecisionTree("hungry");
        hungry.addLeaf(NO, NO);
        hungry.addNode(YES, type);
        DecisionTree patrons = new DecisionTree("patrons");
        patrons.addLeaf("None", NO);
        patrons.addLeaf("Some", YES);
        patrons.addNode("Full", hungry);
        return patrons;
    }

    private static DecisionTree createActualRestaurantDecisionTree() {
        DecisionTree raining = new DecisionTree("raining");
        raining.addLeaf(YES, YES);
        raining.addLeaf(NO, NO);
        DecisionTree bar = new DecisionTree("bar");
        bar.addLeaf(YES, YES);
        bar.addLeaf(NO, NO);
        DecisionTree frisat = new DecisionTree("fri/sat");
        frisat.addLeaf(YES, YES);
        frisat.addLeaf(NO, NO);
        DecisionTree alternate2 = new DecisionTree("alternate");
        alternate2.addNode(YES, raining);
        alternate2.addLeaf(NO, YES);
        DecisionTree reservation = new DecisionTree("reservation");
        frisat.addNode(NO, bar);
        frisat.addLeaf(YES, YES);
        DecisionTree alternate1 = new DecisionTree("alternate");
        alternate1.addNode(NO, reservation);
        alternate1.addNode(YES, frisat);
        DecisionTree hungry = new DecisionTree("hungry");
        hungry.addLeaf(NO, YES);
        hungry.addNode(YES, alternate2);
        DecisionTree waitEstimate = new DecisionTree("wait_estimate");
        waitEstimate.addLeaf(">60", NO);
        waitEstimate.addNode("30-60", alternate1);
        waitEstimate.addNode("10-30", hungry);
        waitEstimate.addLeaf("0-10", YES);
        DecisionTree patrons = new DecisionTree("patrons");
        patrons.addLeaf("None", NO);
        patrons.addLeaf("Some", YES);
        patrons.addNode("Full", waitEstimate);
        return patrons;
    }
}

