/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.fol.domain.DomainFactory;
import aima.logic.fol.domain.FOLDomain;
import aima.logic.fol.parsing.FOLLexer;
import aima.logic.fol.parsing.FOLParser;
import aima.logic.fol.parsing.ast.ConnectedSentence;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.QuantifiedSentence;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import junit.framework.TestCase;

public class FOLParserTest
extends TestCase {
    FOLLexer lexer;
    FOLParser parser;

    @Override
    public void setUp() {
        FOLDomain domain = DomainFactory.crusadesDomain();
        this.lexer = new FOLLexer(domain);
        this.parser = new FOLParser(this.lexer);
    }

    public void testParseSimpleVariable() {
        this.parser.setUpToParse("x");
        Term v = this.parser.parseVariable();
        FOLParserTest.assertEquals(v, new Variable("x"));
    }

    public void testParseIndexedVariable() {
        this.parser.setUpToParse("x1");
        Term v = this.parser.parseVariable();
        FOLParserTest.assertEquals(v, new Variable("x1"));
    }

    public void testNotAllowedParseLeadingIndexedVariable() {
        try {
            this.parser.setUpToParse("1x");
            this.parser.parseVariable();
            FOLParserTest.fail("A Runtime Exception should have been thrown, indicating '1x' is not a valid variable name.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testParseSimpleConstant() {
        this.parser.setUpToParse("John");
        Term c = this.parser.parseConstant();
        FOLParserTest.assertEquals(c, new Constant("John"));
    }

    public void testParseFunction() {
        this.parser.setUpToParse("BrotherOf(John)");
        Term f = this.parser.parseFunction();
        FOLParserTest.assertEquals(f, this.getBrotherOfFunction(new Constant("John")));
    }

    public void testParseMultiArityFunction() {
        this.parser.setUpToParse("LegsOf(John,Saladin,Richard)");
        Term f = this.parser.parseFunction();
        FOLParserTest.assertEquals(f, this.getLegsOfFunction());
        FOLParserTest.assertEquals(3, ((Function)f).getTerms().size());
    }

    public void testPredicate() {
        Predicate p = (Predicate)this.parser.parse("King(John)");
        FOLParserTest.assertEquals(p, this.getKingPredicate(new Constant("John")));
    }

    public void testTermEquality() {
        try {
            TermEquality te = (TermEquality)this.parser.parse("BrotherOf(John) = EnemyOf(Saladin)");
            FOLParserTest.assertEquals(te, new TermEquality(this.getBrotherOfFunction(new Constant("John")), this.getEnemyOfFunction()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testTermEquality2() {
        try {
            TermEquality te = (TermEquality)this.parser.parse("BrotherOf(John) = x)");
            FOLParserTest.assertEquals(te, new TermEquality(this.getBrotherOfFunction(new Constant("John")), new Variable("x")));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testNotSentence() {
        NotSentence ns = (NotSentence)this.parser.parse("NOT BrotherOf(John) = EnemyOf(Saladin)");
        FOLParserTest.assertEquals(ns.getNegated(), new TermEquality(this.getBrotherOfFunction(new Constant("John")), this.getEnemyOfFunction()));
    }

    public void testSimpleParanthizedSentence() {
        Sentence ps = this.parser.parse("(NOT King(John))");
        FOLParserTest.assertEquals(ps, new NotSentence(this.getKingPredicate(new Constant("John"))));
    }

    public void testExtraParanthizedSentence() {
        Sentence ps = this.parser.parse("(((NOT King(John))))");
        FOLParserTest.assertEquals(ps, new NotSentence(this.getKingPredicate(new Constant("John"))));
    }

    public void testParseComplexParanthizedSentence() {
        Sentence ps = this.parser.parse("(NOT BrotherOf(John) = EnemyOf(Saladin))");
        FOLParserTest.assertEquals(ps, new NotSentence(new TermEquality(this.getBrotherOfFunction(new Constant("John")), this.getEnemyOfFunction())));
    }

    public void testParseSimpleConnectedSentence() {
        Sentence ps = this.parser.parse("(King(John) AND NOT King(Richard))");
        FOLParserTest.assertEquals(ps, new ConnectedSentence("AND", this.getKingPredicate(new Constant("John")), new NotSentence(this.getKingPredicate(new Constant("Richard")))));
        ps = this.parser.parse("(King(John) AND King(Saladin))");
        FOLParserTest.assertEquals(ps, new ConnectedSentence("AND", this.getKingPredicate(new Constant("John")), this.getKingPredicate(new Constant("Saladin"))));
    }

    public void testComplexConnectedSentence1() {
        Sentence ps = this.parser.parse("((King(John) AND NOT King(Richard)) OR King(Saladin))");
        FOLParserTest.assertEquals(ps, new ConnectedSentence("OR", new ConnectedSentence("AND", this.getKingPredicate(new Constant("John")), new NotSentence(this.getKingPredicate(new Constant("Richard")))), this.getKingPredicate(new Constant("Saladin"))));
    }

    public void testQuantifiedSentenceWithSingleVariable() {
        Sentence qs = this.parser.parse("FORALL x  King(x)");
        ArrayList<Variable> vars = new ArrayList<Variable>();
        vars.add(new Variable("x"));
        FOLParserTest.assertEquals(qs, new QuantifiedSentence("FORALL", vars, this.getKingPredicate(new Variable("x"))));
    }

    public void testQuantifiedSentenceWithTwoVariables() {
        Sentence qs = this.parser.parse("EXISTS x,y  (King(x) AND BrotherOf(x) = y)");
        ArrayList<Variable> vars = new ArrayList<Variable>();
        vars.add(new Variable("x"));
        vars.add(new Variable("y"));
        ConnectedSentence cse = new ConnectedSentence("AND", this.getKingPredicate(new Variable("x")), new TermEquality(this.getBrotherOfFunction(new Variable("x")), new Variable("y")));
        FOLParserTest.assertEquals(qs, new QuantifiedSentence("EXISTS", vars, cse));
    }

    public void testQuantifiedSentenceWithPathologicalParanthising() {
        Sentence qs = this.parser.parse("(( (EXISTS x,y  (King(x) AND (BrotherOf(x) = y)) ) ))");
        ArrayList<Variable> vars = new ArrayList<Variable>();
        vars.add(new Variable("x"));
        vars.add(new Variable("y"));
        ConnectedSentence cse = new ConnectedSentence("AND", this.getKingPredicate(new Variable("x")), new TermEquality(this.getBrotherOfFunction(new Variable("x")), new Variable("y")));
        FOLParserTest.assertEquals(qs, new QuantifiedSentence("EXISTS", vars, cse));
    }

    public Function getBrotherOfFunction(Term t) {
        ArrayList<Term> l = new ArrayList<Term>();
        l.add(t);
        return new Function("BrotherOf", l);
    }

    public Function getEnemyOfFunction() {
        ArrayList<Term> l = new ArrayList<Term>();
        l.add(new Constant("Saladin"));
        return new Function("EnemyOf", l);
    }

    public Function getLegsOfFunction() {
        ArrayList<Term> l = new ArrayList<Term>();
        l.add(new Constant("John"));
        l.add(new Constant("Saladin"));
        l.add(new Constant("Richard"));
        return new Function("LegsOf", l);
    }

    public Predicate getKingPredicate(Term t) {
        ArrayList<Term> l = new ArrayList<Term>();
        l.add(t);
        return new Predicate("King", l);
    }

    public void testParseMultiArityFunctionEquality() {
        this.parser.setUpToParse("LegsOf(John,Saladin,Richard)");
        Term f = this.parser.parseFunction();
        this.parser.setUpToParse("LegsOf(John,Saladin,Richard)");
        Term f2 = this.parser.parseFunction();
        FOLParserTest.assertEquals(f, f2);
        FOLParserTest.assertEquals(3, ((Function)f).getTerms().size());
    }

    public void testConnectedImplication() {
        this.parser = new FOLParser(DomainFactory.weaponsDomain());
        Sentence s = this.parser.parse("((Missile(m) AND Owns(Nono,m)) => Sells(West , m ,Nono))");
    }
}

